var docuMasker = {
	_currentDocument: null,
	_localizedPhrases: null,
	_mailTemplate: null,
	_startDocument: null,
	_doOcr: false, 
	_ocrPatterns: [],
	_xinhaInitialized: false,
	_workMode: true,
	_maskRectangle: false,
	init: function (localizedPhrases, mailTemplate, startDocument, ocrPatterns) {
		this._localizedPhrases = localizedPhrases;
		this._mailTemplate = mailTemplate || null;
		this._startDocument = startDocument;
		this._doOcr = ocrPatterns && ocrPatterns.length > 0;
		this._ocrPatterns = ocrPatterns;
		//docuMasker.sizePanes();
		docuMasker.setupButtons();
		docuMasker.setupContextMenu();
		docuMasker.setBrush(20);
		docuMasker.setStrokeStyle('#000000');
		docuMasker.drawing.init();

		window.addEventListener('resize', e => {
			docuMasker.sizePanes();
			docuMasker.drawing.paintCurrentPage();
		});

		window.addEventListener("orientationchange", function (event) {
			docuMasker.sizePanes();
			docuMasker.drawing.paintCurrentPage();
		});

		window.addEventListener('beforeunload', (event) => {
			if (docuMasker.drawing._dirty) {
				event.preventDefault();
				event.returnValue = '';
			}
		});

		window.addEventListener("keydown", e => {
			if (e.defaultPrevented) {
				return; // Should do nothing if the default action has been cancelled
			}

			var handled = false;

			if (e.ctrlKey || e.metaKey) {
				if (e.key !== undefined) {
					switch (e.key) {
						case "s":
							docuMasker.drawing.saveDocument();;
							handled = true;
							break;
						case "o":
							if (!docuMasker.drawing._dirty || confirm(docuMasker.localizer("Do you wish to upload a new document? Any changes to your current document will be lost."))) {
								docuMasker.drawing.reset();
								docuMasker.hideContainer("progress-container");
								docuMasker.displayContainer("upload-container");
								docuMasker.hideContainer("split-parent-container");
								docuMasker.displayContainer("upload-file-container");
							}
							handled = true;
							break;
						case "z":
							docuMasker.drawing.undoPaint();
							handled = true;
							break;

						case "y":
							docuMasker.drawing.redoPaint();
							handled = true;
							break;
						case "ArrowUp":
							if (docuMasker.drawing._undoBuffer.length) {
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].minY -= 1;
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].maxY -= 1;
								docuMasker.drawing.paintCurrentPage();
								document.getElementById("thumb_" + docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1]["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
								handled = true;
							}
							break;
						case "ArrowDown":
							if (docuMasker.drawing._undoBuffer.length) {
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].minY += 1;
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].maxY += 1;
								docuMasker.drawing.paintCurrentPage();
								document.getElementById("thumb_" + docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1]["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
								handled = true;
							}
							break;
						case "ArrowLeft":
							if (docuMasker.drawing._undoBuffer.length) {
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].minX -= 1;
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].maxX -= 1;
								docuMasker.drawing.paintCurrentPage();
								document.getElementById("thumb_" + docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1]["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
								handled = true;
							}
							break;
						case "ArrowRight":
							if (docuMasker.drawing._undoBuffer.length) {
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].minX += 1;
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].maxX += 1;
								docuMasker.drawing.paintCurrentPage();
								document.getElementById("thumb_" + docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1]["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
								handled = true;
							}
							break;
					}
				} else if (e.keyCode !== undefined) {
					switch (e.keyCode) {
						case 26:
							docuMasker.drawing.undoPaint();
							handled = true;
							break;

						case 25:
							docuMasker.drawing.redoPaint();
							handled = true;
							break;
						case 37: // ArrowLeft
							break;
						case 38: // ArrowUp
							break;
						case 39: // ArrowRight
							break;
						case 40: // ArrowDown
							break;
					}
				}
			}
			else if (e.shiftKey) {
				if (e.key !== undefined) {
					switch (e.key) {
						case "ArrowUp":
							if (docuMasker.drawing._undoBuffer.length && docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].lineWidth < 300) {
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].lineWidth += 1;
								docuMasker.drawing.paintCurrentPage();
								document.getElementById("thumb_" + docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1]["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
								handled = true;
							}
							break;
						case "ArrowDown":
							if (docuMasker.drawing._undoBuffer.length && docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].lineWidth > 2) {
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].lineWidth -= 1;
								docuMasker.drawing.paintCurrentPage();
								document.getElementById("thumb_" + docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1]["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
								handled = true;
							}
							break;
						case "ArrowLeft":
							if (docuMasker.drawing._undoBuffer.length && docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].maxX - docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].minX > 2) {
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].maxX -= 1;
								docuMasker.drawing.paintCurrentPage();
								document.getElementById("thumb_" + docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1]["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
								handled = true;
							}
							break;
						case "ArrowRight":
							if (docuMasker.drawing._undoBuffer.length) {
								docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1].maxX += 1;
								docuMasker.drawing.paintCurrentPage();
								document.getElementById("thumb_" + docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length - 1]["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
								handled = true;
							}
							break;
					}
				}
			}
			if (handled) {
				e.preventDefault();
			}
		}, true);

		document.addEventListener("paste", e => {
			if (document.getElementById("upload-container").offsetParent !== null) { // Only consume paste if the upload container is visible
				var items = e.clipboardData.items;
				if (items.length && items[0].getAsFile() != null) {
					if (!docuMasker.drawing._dirty || confirm(docuMasker.localizer("Do you wish to upload a new document? Any changes to your current document will be lost."))) {
						docuMasker.drawing.reset();
						docuMasker.hideContainer("progress-container");
						docuMasker.displayContainer("upload-container");
						docuMasker.hideContainer("split-parent-container");
						docuMasker.displayContainer("upload-file-container");
						docuMasker.docToImg(items[0].getAsFile(), "?paste=true");
					}
				} else {
					navigator.clipboard.readText().then(text => {
						if (!docuMasker.drawing._dirty || confirm(docuMasker.localizer("Do you wish to upload a new document? Any changes to your current document will be lost."))) {
							docuMasker.drawing.reset();
							docuMasker.hideContainer("progress-container");
							docuMasker.displayContainer("upload-container");
							docuMasker.hideContainer("split-parent-container");
							docuMasker.displayContainer("upload-file-container");
							docuMasker.docToImg(text, "?paste=true&type=txt");
						}
					});
				}
			}
		});

		window.addEventListener("click", e => {
			if (!e.target.matches('.dropbtn')) {
				var dropdowns = document.getElementsByClassName("dropdown-content");
				for (var i = 0; i < dropdowns.length; i++) {
					var openDropdown = dropdowns[i];
					if (openDropdown.classList.contains('show')) {
						openDropdown.classList.remove('show');
					}
				}
			}
			if (e.target.matches('.close')) {
				document.getElementById("modal-mailform").style.display = "none";
			}
		});

		Array.from(document.getElementsByClassName("send-button")).forEach(function (element) {
			element.addEventListener('click', e => {
				switch (e.target.id) {
					case "send-mail-button":
						if (!document.getElementById("mail-to").value) {
							document.getElementById("mail-error-message").innerHTML = docuMasker.localizer("You must enter a recipient email address.");
						}
						else if (!docuMasker.validateEmail(document.getElementById("mail-to").value)) {
							document.getElementById("mail-error-message").innerHTML = docuMasker.localizer("You have entered an invalid email address.");
						}
						else {
							var email = {
								"to": document.getElementById("mail-to").value,
								"subject": document.getElementById("mail-subject").value || "",
								"message": Xinha.getEditor("mail-body").getEditorContent() || "",
								"attachmentName": document.getElementById("mail-attachment").value || docuMasker.localizer("Document")
							};
							if (!email["attachmentName"].toLowerCase().endsWith(".pdf"))
								email["attachmentName"] += ".pdf";
							document.getElementById("mail-error-message").innerHTML = "";
							document.getElementById("mail-to").value = "";
							document.getElementById("mail-subject").value = "";
							Xinha.getEditor("mail-body").setEditorContent(docuMasker._mailTemplate && docuMasker._mailTemplate["message"] ? unescape(docuMasker._mailTemplate["message"]) : "");

							document.getElementById("mail-attachment").value = docuMasker.localizer("Document");
							document.getElementById("modal-mailform").style.display = "none";
							docuMasker.drawing.sendDocument(email);
						}
						break;
				}
			});
		});

		Array.from(document.getElementsByClassName("btn")).forEach(function (element) {
			element.addEventListener('click', e => {
				switch (e.target.id) {
					case "btn-save":
						docuMasker.drawing.saveDocument();
						break;

					case "btn-email":
						docuMasker.displayMailForm();
						break;

					case "btn-upload":
						if (!docuMasker.drawing._dirty || confirm(docuMasker.localizer("Do you wish to upload a new document? Any changes to your current document will be lost."))) {
							docuMasker.drawing.reset();
							docuMasker.hideContainer("progress-container");
							docuMasker.displayContainer("upload-container");
							docuMasker.hideContainer("split-parent-container");
							docuMasker.displayContainer("upload-file-container");
						}
						break;

					case "btn-work-mode":
						docuMasker._workMode = !docuMasker._workMode;
						if (docuMasker._workMode) {
							document.getElementById("btn-work-mode").classList.remove("btn-masked-mode");
							document.getElementById("btn-work-mode").classList.add("btn-work-mode");
							document.getElementById("btn-work-mode").src = "./Images/mode_work.svg";
						}
						else {
							document.getElementById("btn-work-mode").classList.remove("btn-work-mode");
							document.getElementById("btn-work-mode").classList.add("btn-masked-mode");
							document.getElementById("btn-work-mode").src = "./Images/mode_masked.svg";
						}
						docuMasker.drawing.paintCurrentPage();
						break;

					case "btn-brush":
						break;

					case "btn-undo":
						docuMasker.drawing.undoPaint();
						break;

					case "btn-redo":
						docuMasker.drawing.redoPaint();
						break;
				}
			});
		});



		if (window.File && window.FileList && window.FileReader) {
			var fileselect = document.getElementById("fileselect"),
				filedrag = document.getElementById("filedrag"),
				submitbutton = document.getElementById("submitbutton");

			fileselect.addEventListener("change", e => {
				if (fileselect.value != null) {
					e.stopPropagation();
					e.preventDefault();
					e.target.className = (e.type == "dragover" ? "hover" : "");
					docuMasker.docToImg((e.target.files || e.dataTransfer.files)[0]);
				}
			}, false);

			if (new XMLHttpRequest().upload) {
				filedrag.addEventListener("dragover", e => {
					e.stopPropagation();
					e.preventDefault();
					e.target.className = (e.type == "dragover" ? "hover" : "");
				}, false);
				filedrag.addEventListener("dragleave", e => {
					e.stopPropagation();
					e.preventDefault();
					e.target.className = (e.type == "dragover" ? "hover" : "");
				}, false);
				filedrag.addEventListener("drop", e => {
					e.stopPropagation();
					e.preventDefault();
					e.target.className = (e.type == "dragover" ? "hover" : "");
					docuMasker.docToImg((e.target.files || e.dataTransfer.files)[0]);
				}, false);
				filedrag.style.display = docuMasker.mobileCheck() ? "none" : "block";
				submitbutton.style.display = "none";
			}
		}

		if (docuMasker._startDocument) {
			docuMasker.docToImg(docuMasker.base64toBlob(docuMasker._startDocument));
			docuMasker._startDocument = "";
		}
		else if (docuMasker.getCsd()) {
			try {
				var request = new XMLHttpRequest();
				request.open('GET', docuMasker.getCsd(), true);
				request.responseType = "blob";
				request.withCredentials = true;
				request.onreadystatechange = function () {
					if (request.readyState === 4 && request.status === 200) {
						docuMasker.docToImg(request.response);
					}
				}
				request.send(null);
			} catch (ex) {
				console.log(ex);
			}
		}
	},
	getCsd: function (url = window.location.href) {
		var regex = new RegExp('[?&]csd=(.*)$');
		var results = regex.exec(url);
		if (!results) return null;
		if (!results[1]) return '';
		return decodeURIComponent(results[1].replace(/\+/g, ' '));
	},
	getQueryParameterByName: function (name, url = window.location.href) {
		name = name.replace(/[\[\]]/g, '\\$&');
		var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
			results = regex.exec(url);
		if (!results) return null;
		if (!results[2]) return '';
		return decodeURIComponent(results[2].replace(/\+/g, ' '));
	},
	base64toBlob: function (base64Data, contentType) {
		contentType = contentType || '';
		var sliceSize = 1024;
		var byteCharacters = atob(base64Data);
		var bytesLength = byteCharacters.length;
		var slicesCount = Math.ceil(bytesLength / sliceSize);
		var byteArrays = new Array(slicesCount);

		for (var sliceIndex = 0; sliceIndex < slicesCount; ++sliceIndex) {
			var begin = sliceIndex * sliceSize;
			var end = Math.min(begin + sliceSize, bytesLength);

			var bytes = new Array(end - begin);
			for (var offset = begin, i = 0; offset < end; ++i, ++offset) {
				bytes[i] = byteCharacters[offset].charCodeAt(0);
			}
			byteArrays[sliceIndex] = new Uint8Array(bytes);
		}
		return new Blob(byteArrays, { type: contentType });
	},
	mobileCheck: function () {
		let check = false;
		(function (a) { if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) check = true; })(navigator.userAgent || navigator.vendor || window.opera);
		return check;
	},
	mobileAndTabletCheck: function () {
		let check = false;
		(function (a) { if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) check = true; })(navigator.userAgent || navigator.vendor || window.opera);
		return check;
	},
	validateEmail: function (email) {
		// for unicode support // const re = /^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
		const re = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
		return re.test(String(email).toLowerCase());
	},
	localizer: function (phrase) {
		return (this._localizedPhrases && this._localizedPhrases[phrase]) ? this._localizedPhrases[phrase] : phrase;
	},
	toggleDropdownButton: function (id) {
		document.getElementById(id).classList.toggle("show");
	},
	displayMailForm: function () {
		document.getElementById("mail-subject").value = docuMasker._mailTemplate && docuMasker._mailTemplate["subject"] ? docuMasker._mailTemplate["subject"] : "";
		document.getElementById("mail-body").innerHTML = docuMasker._mailTemplate && docuMasker._mailTemplate["message"] ? unescape(docuMasker._mailTemplate["message"]) : "";
		document.getElementById("modal-mailform").style.display = 'block';
		if (!docuMasker._xinhaInitialized) {
			xinha_init();
			docuMasker._xinhaInitialized = true;
		}
	},
	setupContextMenu: function () {
		var currentThumb = null;
		const menu = document.createElement("div");
		menu.classList.add("contextmenu");
		const menuOptions = document.createElement("ul");
		menuOptions.classList.add("contextmenu-options");

		const deletePageMenuOption = document.createElement("li");
		deletePageMenuOption.classList.add("contextmenu-option");
		deletePageMenuOption.innerText = docuMasker.localizer("Delete page");

		const restorePageMenuOption = document.createElement("li");
		restorePageMenuOption.classList.add("contextmenu-option");
		restorePageMenuOption.innerText = docuMasker.localizer("Restore page");

		document.body.appendChild(menu);
		menu.appendChild(menuOptions);
		menuOptions.appendChild(deletePageMenuOption);
		menuOptions.appendChild(restorePageMenuOption);

		deletePageMenuOption.addEventListener('click', ce => {
			try {
				if (currentThumb) {
					const pageNr = 1 * currentThumb.getAttribute("data-pagenumber");
					var page = docuMasker.drawing._pages[pageNr];
					docuMasker.drawing.setCurrentPage(pageNr);

					var tmp = [];
					for (var p = 0; p < docuMasker.drawing._undoBuffer.length; p++) {
						if (docuMasker.drawing._undoBuffer[p]["pageNumber"] != pageNr) {
							tmp[tmp.length] = docuMasker.drawing._undoBuffer[p];
						}
					}
					docuMasker.drawing._undoBuffer = tmp;

					if (page["original"].deletedOriginal) {
						docuMasker.drawing.paintCurrentPage();
						document.getElementById("thumb_" + pageNr).src = page["original"].src;
					} else {
						var delImgSrc = docuMasker.drawing.paintDeletedImage(pageNr);
						document.getElementById("thumb_" + pageNr).src = delImgSrc;
						page["original"].deletedOriginal = page["original"].src;
						page["original"].src = delImgSrc;
					}
				}
			} catch (ex) {
				console.log(ex);
            }
			currentThumb = null;
		});

		restorePageMenuOption.addEventListener('click', ce => {
			try {
				if (currentThumb) {
					const pageNr = 1 * currentThumb.getAttribute("data-pagenumber");
					console.log(pageNr);
					var page = docuMasker.drawing._pages[pageNr];
					if (page["original"].deletedOriginal) {
						document.getElementById("thumb_" + pageNr).src = page["original"].deletedOriginal;
						page["original"].src = page["original"].deletedOriginal;
						page["original"].deletedOriginal = null;
						docuMasker.drawing.setCurrentPage(pageNr);
                    }
				}
			} catch (ex) {
				console.log(ex);
			}
			currentThumb = null;
		});

		const displayMenu = (e) => {
			currentThumb = e.target;
			const pageNr = 1 * currentThumb.getAttribute("data-pagenumber");
			var page = docuMasker.drawing._pages[pageNr];
			restorePageMenuOption.style.display = (page["original"].deletedOriginal) ? "block" : "none";
			menu.style.left = e.pageX.toString() + "px";
			menu.style.top = e.pageY.toString() + "px";
			menu.style.display = "block";
		};

		window.addEventListener("click", e => {
			if (menu.style.display === "block")
				menu.style.display = "none";
			currentThumb = null;
		});

		window.addEventListener("contextmenu", e => {
			e.preventDefault();
			if (e.target.matches('.thumb-image')) {
				displayMenu( e );
			}
			return false;
		});
	},
	colorAlias: function (color) {
		switch (color) {
			case "#FFFFFF": return "white";
			case "#000000": return "black";
			case "#DE8D00": return "orange";

			case "#FF0000": return "red";
			case "#008000": return "green";
			case "#0000FF": return "blue";

			case "#00FFFF": return "cyan";
			case "#FF00FF": return "magenta";
			case "#FFFF00": return "yellow";
		}
		return "black";
	},
	setCursor: function () {
		try {
			var epc = document.getElementById("editor-pane-canvas");
			epc.classList.forEach(function (cls) {
				if (cls.startsWith("brush-cursor")) {
					epc.classList.remove(cls);
				}
			});
			if (docuMasker._maskRectangle) {
				epc.classList.add('brush-cursor-rectangle');
			} else {
				epc.classList.add('brush-cursor-' + docuMasker.colorAlias(docuMasker.drawing._strokeStyle) + '-' + docuMasker.drawing._lineWidth.toString());
			}
		} catch (ex) {
			console.log(ex);
		}
	},
	setBrush: function (width, type) {
		docuMasker._maskRectangle = (type && type === 'rectangle');
		docuMasker.drawing._lineWidth = width;
		docuMasker.setCursor();
	},
	setStrokeStyle: function (style) {
		docuMasker.drawing._strokeStyle = style;
		docuMasker.setCursor();
	},
	sizePanes: function () {
		try {
			var lp = document.getElementById("left-pane");
			var rp = document.getElementById("right-pane");
			var ep = document.getElementById("editor-pane");
			var tp = document.getElementById("toolbar-pane");

			rp.style.width = (window.innerWidth - lp.offsetWidth - 1) + "px";
			ep.style.height = (rp.offsetHeight - tp.offsetHeight - 1) + "px";
		} catch (ex) {
			console.log(ex);
        }
	},
	setupButtons: function () {
		var btnUndo = document.getElementById("btn-undo");
		var btnRedo = document.getElementById("btn-redo");

		if (docuMasker.drawing._undoBuffer.length == 0) {
			btnUndo.disabled = true;
			btnUndo.src = "./Images/undo-disabled.svg";
		} else {
			btnUndo.disabled = false;
			btnUndo.src = "./Images/undo.svg";
		}

		if (docuMasker.drawing._redoBuffer.length == 0) {
			btnRedo.disabled = true;
			btnRedo.src = "./Images/redo-disabled.svg";
		} else {
			btnRedo.disabled = false;
			btnRedo.src = "./Images/redo.svg";
		}
	},
	isHidden: function (el) {
		var style = window.getComputedStyle(el);
		return (style.display === 'none')
	},
	displayContainer: function (id) {
		try {
			var el = document.getElementById(id);
			if (el) {
				if (el.classList.contains('hidden-container')) {
					el.classList.remove('hidden-container');
				}
			}
		} catch (ex) {
			console.log(ex);
		}
	},
	hideContainer: function (id) {
		try {
			var el = document.getElementById(id);
			if (el) {
				if (!el.classList.contains('hidden-container')) {
					el.classList.add('hidden-container');
				}
			}
		} catch (ex) {
			console.log(ex);
		}
	},
	toggleContainerVisibility: function (id) {
		try {
			var el = document.getElementById(id);
			if (el) {
				if (el.classList.contains('hidden-container')) {
					el.classList.remove('hidden-container');
				} else {
					el.classList.add('hidden-container');
				}
			}
		} catch (ex) {
			console.log(ex);
		}
	},
	_invoke: function (url, method, data, cb) {
		var xhr = new XMLHttpRequest();
		xhr.addEventListener('progress', e => { });
		xhr.addEventListener('load', e => {
			if (xhr.readyState == 4) {
				if (xhr.status == 200) {
					cb(xhr.responseText);
				} else {
					console.log(xhr.status + " " + xhr.statusText);
					throw xhr.status + " " + xhr.statusText;
				}
			}
		});
		xhr.addEventListener('error', e => { docuMasker.displayContainer("upload-container"); docuMasker.hideContainer("progress-container"); alert(xhr.responseText); });
		xhr.addEventListener('abort', e => { docuMasker.displayContainer("upload-container"); docuMasker.hideContainer("progress-container"); alert(docuMasker.localizer("The operation was aborted.")); });
		xhr.open(method, url, true);
		xhr.send(data);
	},
	docToImg: function (file, queryString) {
		docuMasker.hideContainer("upload-container");
		docuMasker.displayContainer("progress-container");
		docuMasker.drawing.reset();
		docuMasker._currentDocument = file.name;

		var xhr = new XMLHttpRequest();
		xhr.addEventListener('progress', e => { });
		xhr.addEventListener('error', e => { docuMasker.displayContainer("upload-container"); docuMasker.hideContainer("progress-container"); alert(xhr.responseText); });
		xhr.addEventListener('abort', e => { docuMasker.displayContainer("upload-container"); docuMasker.hideContainer("progress-container"); alert(docuMasker.localizer("The operation was aborted.")); });
		xhr.addEventListener('load', e => {
			if (xhr.readyState == 4) {
				if (xhr.status == 200) {
					try {
						var data = JSON.parse(xhr.responseText);
						if (data && data.pages && data.pages.length) {
							docuMasker.hideContainer("upload-file-container");
							docuMasker.displayContainer("split-parent-container");
							docuMasker.sizePanes();
							docuMasker.drawing.loadDocument(data);
						}
						else {
							docuMasker.displayContainer("upload-container");
							docuMasker.hideContainer("progress-container");
							alert(docuMasker.localizer("We are not able to load this document."));
						}
					}
					catch (ex) {
						docuMasker.displayContainer("upload-container");
						docuMasker.hideContainer("progress-container");
						alert(docuMasker.localizer("We are not able to load this document."));
					}
				}
				else {
					docuMasker.displayContainer("upload-container");
					docuMasker.hideContainer("progress-container");
					console.log(xhr.status + " " + xhr.statusText);
					alert(docuMasker.localizer("We are not able to load this document.") + "\r\n" + xhr.status + " " + xhr.statusText);
				}
				document.getElementById("fileselect").value = null;
			}
		});
		xhr.open("POST", '/Document/ToImg' + (queryString || ""), true);
		xhr.send(file);
	},
	drawing: {
		_canvas: null,
		_ctx: null,
		_currentPage: -1,
		_dirty: false,
		_lineWidth: 16,
		_strokeStyle: "#000000",
		_zoom: 1,
		_pages: [],
		_undoBuffer: [],
		_redoBuffer: [],
		_ocrWorker: null,
		init: function () {
			docuMasker.drawing._canvas = document.getElementById('editor-pane-canvas');
			docuMasker.drawing._ctx = docuMasker.drawing._canvas.getContext('2d');

			if(docuMasker._doOcr) {
				docuMasker.drawing._ocrWorker = new Tesseract.createWorker({
					logger: docuMasker.drawing.ocrProgress
				});
				docuMasker.drawing.loadTesseractAsync("swe");
			}
			var mouseIsDown = false,
				currX = 0,
				currY = 0,
				currY = 0,
				minX = 0,
				minY = 0,
				maxX = 0,
				maxY = 0,
				startX = 0,
				startY = 0,
				originalImageData = null;

			var toX = function (e) {
				try {
					return e.changedTouches[0].clientX;
				} catch (ex) {
					return e.clientX;
				}
			};

			var toY = function (e) {
				try {
					return e.changedTouches[0].clientY;
				} catch (ex) {
					return e.clientY;
				}
			};

			var startPaint = function (e) {
				e.preventDefault();
				mouseIsDown = true;
				startX = minX = maxX = currX = toX(e) - docuMasker.drawing._canvas.offsetLeft + document.getElementById('editor-pane').scrollLeft;
				startY = minY = maxY = currY = toY(e) - docuMasker.drawing._canvas.offsetTop + document.getElementById('editor-pane').scrollTop;
				originalImageData = docuMasker.drawing._ctx.getImageData(0, 0, docuMasker.drawing._canvas.width, docuMasker.drawing._canvas.height);
			};

			var endPaint = function (e) {
				if (mouseIsDown) {
					e.preventDefault();
					mouseIsDown = false;
					minX = Math.min(startX, toX(e) - docuMasker.drawing._canvas.offsetLeft + document.getElementById('editor-pane').scrollLeft);
					maxX = Math.max(startX, toX(e) - docuMasker.drawing._canvas.offsetLeft + document.getElementById('editor-pane').scrollLeft);
					if (docuMasker._maskRectangle) {
						minY = Math.min(startY, toY(e) - docuMasker.drawing._canvas.offsetTop + document.getElementById('editor-pane').scrollTop);
						maxY = Math.max(startY, toY(e) - docuMasker.drawing._canvas.offsetTop + document.getElementById('editor-pane').scrollTop);
					}
					if (docuMasker.drawing._currentPage >= 0) {
						var page = docuMasker.drawing.getPage(docuMasker.drawing._currentPage);
						var boundingWidth = document.getElementById("editor-pane").getBoundingClientRect().width;
						var boundingHeight = document.getElementById("editor-pane").getBoundingClientRect().height;
						var canvasWHFactor = boundingWidth / boundingHeight;
						var imgWHFactor = page["original"].naturalWidth / page["original"].naturalHeight;
						var canvasWidth = ((imgWHFactor >= canvasWHFactor) ? boundingWidth : boundingHeight * imgWHFactor) * docuMasker.drawing._zoom;
						var canvasHeight = ((imgWHFactor >= canvasWHFactor) ? boundingWidth / imgWHFactor : boundingHeight) * docuMasker.drawing._zoom;

						docuMasker.drawing.paint(docuMasker.drawing._canvas.toDataURL("image/png", 1.0), {
							"pageNumber": docuMasker.drawing._currentPage,
							"minX": minX,
							"minY": minY,
							"maxX": maxX,
							"maxY": maxY,
							"lineWidth": docuMasker._maskRectangle ? maxY - minY : docuMasker.drawing._lineWidth,
							"strokeStyle": docuMasker.drawing._strokeStyle,
							"canvasWidth": canvasWidth,
							"canvasHeight": canvasHeight
						});
					}
					startX = startY = minX = maxX = currX = minY = maxY = currY = 0;
				}
			};

			var doPaint = function (e) {
				if (!mouseIsDown) return;
				e.preventDefault();
				try {
					// xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
					docuMasker.drawing._ctx.putImageData(originalImageData, 0, 0, 0, 0, docuMasker.drawing._canvas.width, docuMasker.drawing._canvas.height);
					var strokeStyle = docuMasker._workMode ? docuMasker.drawing.hexToRgba(docuMasker.drawing._strokeStyle, 0.5) : docuMasker.drawing._strokeStyle;
					currX = toX(e) - docuMasker.drawing._canvas.offsetLeft + document.getElementById('editor-pane').scrollLeft;
					currY = toY(e) - docuMasker.drawing._canvas.offsetTop + document.getElementById('editor-pane').scrollTop;
					docuMasker.drawing._ctx.beginPath();
					docuMasker.drawing._ctx.moveTo(startX, docuMasker._maskRectangle ? startY + (currY - startY) / 2 : startY + docuMasker.drawing._lineWidth / 2);
					docuMasker.drawing._ctx.lineTo(currX, docuMasker._maskRectangle ? startY + (currY - startY) / 2 : startY + docuMasker.drawing._lineWidth / 2);
					docuMasker.drawing._ctx.lineWidth = docuMasker._maskRectangle ? Math.abs(startY - currY) : docuMasker.drawing._lineWidth;
					docuMasker.drawing._ctx.strokeStyle = strokeStyle;
					docuMasker.drawing._ctx.stroke();
				} catch (x) {
					console.log(x);
				}
			};

			docuMasker.drawing._canvas.addEventListener("mousedown", startPaint, false);
			docuMasker.drawing._canvas.addEventListener("mouseup", endPaint, false);
			docuMasker.drawing._canvas.addEventListener("mouseout", endPaint, false);
			docuMasker.drawing._canvas.addEventListener("mousemove", doPaint, false);

			docuMasker.drawing._canvas.addEventListener("touchstart", startPaint, false);
			docuMasker.drawing._canvas.addEventListener("touchend", endPaint, false);
			docuMasker.drawing._canvas.addEventListener("touchcancel", endPaint, false);
			docuMasker.drawing._canvas.addEventListener("touchmove", doPaint, false);
		},
		ocrProgress: function (packet){
		}, 
		loadTesseractAsync: async function(language) {
			console.log("Loading Tesseract - " + new Date().toISOString());
			await docuMasker.drawing._ocrWorker.load();
			console.log("Loading language - " + language);
			await docuMasker.drawing._ocrWorker.loadLanguage(language);
			console.log("Initializing language - " + language);
			await docuMasker.drawing._ocrWorker.initialize(language);
			console.log("Loading Tesseract completed - " + new Date().toISOString());
		}, 
		recognizeAsync: async function() {
			var idx = 0;
			console.log("Start recognizeAsync - " + new Date().toISOString());
			while(idx < docuMasker.drawing._pages.length) {
				const { data } = await docuMasker.drawing._ocrWorker.recognize(docuMasker.drawing._pages[idx].original);
				console.log(idx);
				console.log(data);
				docuMasker.drawing._pages[idx++].ocrData = data;
			}
			console.log("recognizeAsync done - " + new Date().toISOString());
			
			docuMasker.drawing.rxMask();
		}, 
		recognize: function() {
			if(docuMasker.drawing._pages.length > 0) {
				docuMasker.drawing.recognizeAsync();
			}
		}, 
		rxMask: function() {
			var cp = docuMasker.drawing._currentPage;
			var ul = docuMasker.drawing._undoBuffer.length;
			for(var p=0; p<docuMasker.drawing._pages.length;p++) {
				docuMasker.drawing.rxFind(docuMasker.drawing._pages[p], docuMasker._ocrPatterns);
			}
			docuMasker.drawing.setCurrentPage(cp);
			if(ul != docuMasker.drawing._undoBuffer.length) {
				docuMasker.drawing._redoBuffer = [];
				docuMasker.drawing._dirty = true;
				docuMasker.setupButtons();
			}
		}, 
		rxFind: function(page, rxPatterns) {
			rxPatterns.forEach(function(rx) {
				if(rx && page.ocrData && page.ocrData.text) {
					console.log("rxFind - " + rx);
					const found = page.ocrData.text.match(new RegExp(rx, 'igm'));
					console.log('rx match:', found);
					if(found) {
						var handled = {};
						var boundingWidth = document.getElementById("editor-pane").getBoundingClientRect().width;
						var boundingHeight = document.getElementById("editor-pane").getBoundingClientRect().height;
						var canvasWHFactor = boundingWidth / boundingHeight;
						var imgWHFactor = page["original"].naturalWidth / page["original"].naturalHeight;
						var canvasWidth = ((imgWHFactor >= canvasWHFactor) ? boundingWidth : boundingHeight * imgWHFactor) * docuMasker.drawing._zoom;
						var canvasHeight = ((imgWHFactor >= canvasWHFactor) ? boundingWidth / imgWHFactor : boundingHeight) * docuMasker.drawing._zoom;
						var scaleFactor = canvasWidth / page["original"].naturalWidth;

						found.forEach(function(rxmatch) {
							var fnd = rxmatch.replaceAll(/\s*/g, '');
							if(!handled[fnd]) {
								handled[fnd] = true;
								for(var sIdx = 0; sIdx < page.ocrData.symbols.length - fnd.length; sIdx++) {
									var found = true;
									for(var cIdx = 0; found && cIdx < fnd.length; cIdx++) {
										if(page.ocrData.symbols[sIdx + cIdx].text != fnd[cIdx].toString())
											found = false;
									}
									if(found) {
										var line = {};
										for(var ix = sIdx; ix < sIdx + fnd.length; ix++) {
											var b = page.ocrData.symbols[ix].bbox;
											
											if(page.ocrData.symbols[ix].baseline && page.ocrData.symbols[ix].baseline.has_baseline)
											{
												if(line && line["baseline_y0"] && line["baseline_y1"] && (line["baseline_y0"] != page.ocrData.symbols[ix].baseline.y0 || line["baseline_y1"] != page.ocrData.symbols[ix].baseline.y1)) {
													var lineOffset = (docuMasker.drawing._lineWidth - (line["bottom"]*scaleFactor - line["top"]*scaleFactor))/2;
													docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length] = {
														"pageNumber": page["pageNumber"],
														"minX": line["left"]*scaleFactor,
														"minY": line["top"]*scaleFactor-lineOffset,
														"maxX": line["right"]*scaleFactor,
														"maxY": line["bottom"]*scaleFactor-lineOffset,
														"lineWidth": docuMasker.drawing._lineWidth,
														"strokeStyle": docuMasker.drawing._strokeStyle,
														"canvasWidth": canvasWidth,
														"canvasHeight": canvasHeight
													};
													line = {};
												}
												line["top"] = Math.min(line["top"] || b.y0, b.y0);
												line["left"] = Math.min(line["left"] || b.x0, b.x0);
												line["bottom"] = Math.max(line["bottom"] || b.y1, b.y1);
												line["right"] = Math.max(line["right"] || b.x1, b.x1);
												line["baseline_y0"] = page.ocrData.symbols[ix].baseline.y0;
												line["baseline_y1"] = page.ocrData.symbols[ix].baseline.y1;
											}
											else
											{
												
												if(line && (line["top"] || line["left"] || line["bottom"] || line["right"])) {
													var lineOffset = (docuMasker.drawing._lineWidth - (line["bottom"]*scaleFactor - line["top"]*scaleFactor))/2;
													docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length] = {
														"pageNumber": page["pageNumber"],
														"minX": line["left"]*scaleFactor,
														"minY": line["top"]*scaleFactor-lineOffset,
														"maxX": line["right"]*scaleFactor,
														"maxY": line["bottom"]*scaleFactor-lineOffset,
														"lineWidth": docuMasker.drawing._lineWidth,
														"strokeStyle": docuMasker.drawing._strokeStyle,
														"canvasWidth": canvasWidth,
														"canvasHeight": canvasHeight
													};
													line = {};
												}
												var lineOffset = (docuMasker.drawing._lineWidth - (b.y1*scaleFactor - b.y0*scaleFactor))/2;
												docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length] = {
													"pageNumber": page["pageNumber"],
													"minX": b.x0*scaleFactor,
													"minY": b.y0*scaleFactor-lineOffset,
													"maxX": b.x1*scaleFactor,
													"maxY": b.y1*scaleFactor-lineOffset,
													"lineWidth": docuMasker.drawing._lineWidth,
													"strokeStyle": docuMasker.drawing._strokeStyle,
													"canvasWidth": canvasWidth,
													"canvasHeight": canvasHeight
												};
											}
										}
										if(line && (line["top"] || line["left"] || line["bottom"] || line["right"])) {
											var lineOffset = (docuMasker.drawing._lineWidth - (line["bottom"]*scaleFactor - line["top"]*scaleFactor))/2;
											docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length] = {
												"pageNumber": page["pageNumber"],
												"minX": line["left"]*scaleFactor,
												"minY": line["top"]*scaleFactor-lineOffset,
												"maxX": line["right"]*scaleFactor,
												"maxY": line["bottom"]*scaleFactor-lineOffset,
												"lineWidth": docuMasker.drawing._lineWidth,
												"strokeStyle": docuMasker.drawing._strokeStyle,
												"canvasWidth": canvasWidth,
												"canvasHeight": canvasHeight
											};
											line = {};
										}
									}
								}
							}
						});
					}
				}
			});
			docuMasker.drawing.setCurrentPage(page["pageNumber"]);
			docuMasker.drawing.paintPage(page["pageNumber"]);
			document.getElementById("thumb_" + page["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
		}, 
		reset: function () {
			docuMasker.drawing._pages = [];
			docuMasker.drawing._undoBuffer = [];
			docuMasker.drawing._redoBuffer = [];
			docuMasker.drawing._dirty = false;
			docuMasker.drawing._currentPage = -1;
			document.getElementById("left-pane-content").innerHTML = "";
			docuMasker.drawing._ctx.clearRect(0, 0, docuMasker.drawing._canvas.width, docuMasker.drawing._canvas.height);
		},
		setZoom: function (factor) {
			docuMasker.drawing._zoom = factor;
			docuMasker.drawing.paintCurrentPage();
		},
		getPage: function (pageNumber) {
			if (pageNumber >= 0 && pageNumber < docuMasker.drawing._pages.length) {
				return docuMasker.drawing._pages[pageNumber];
			} else {
				return null;
			}
		},
		undoPaint: function () {
			if (docuMasker.drawing._undoBuffer.length) {
				var undoPage = docuMasker.drawing._undoBuffer.pop();
				docuMasker.drawing._redoBuffer[docuMasker.drawing._redoBuffer.length] = undoPage;
				docuMasker.drawing.setCurrentPage(undoPage["pageNumber"]);
				docuMasker.drawing.paintPage(undoPage["pageNumber"]);
				document.getElementById("thumb_" + undoPage["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
			}
			docuMasker.drawing._dirty = (docuMasker.drawing._undoBuffer.length > 0);
			docuMasker.setupButtons();
		},
		redoPaint: function () {
			if (docuMasker.drawing._redoBuffer.length) {
				var redoPage = docuMasker.drawing._redoBuffer.pop();
				docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length] = redoPage;
				docuMasker.drawing.setCurrentPage(redoPage["pageNumber"]);
				docuMasker.drawing.paintPage(redoPage["pageNumber"]);
				document.getElementById("thumb_" + redoPage["pageNumber"]).src = docuMasker.drawing._canvas.toDataURL("image/png", 1.0);
			}
			docuMasker.setupButtons();
		},
		paint: function (dataUrl, lineInfo) {
			var page = docuMasker.drawing.getPage(lineInfo["pageNumber"]);
			if (page != null) {
				docuMasker.drawing._undoBuffer[docuMasker.drawing._undoBuffer.length] = lineInfo;
				document.getElementById("thumb_" + lineInfo["pageNumber"]).src = dataUrl;
				docuMasker.drawing._redoBuffer = [];
			}
			docuMasker.drawing._dirty = true;
			docuMasker.setupButtons();
		},
		setCurrentPage: function (pageNumber) {
			if (pageNumber >= 0 && docuMasker.drawing._pages.length > pageNumber) {
				docuMasker.drawing._currentPage = pageNumber;
				try {
					Array.from(document.getElementsByClassName("thumb-c2")).forEach(function (element) {
						if (element.classList.contains('thumb-selected')) element.classList.remove('thumb-selected');
					});
					document.getElementById("thumb_" + pageNumber.toString()).parentElement.parentElement.classList.add('thumb-selected');
				} catch (ex) {
					console.log(ex);
				}
			} else docuMasker.drawing._currentPage = -1;
		},
		paintDeletedImage: function (pageNumber) {
			var page = docuMasker.drawing.getPage(pageNumber);
			var canvas = document.createElement('canvas');
			var ctx = canvas.getContext('2d');
			canvas.style.margin = 0;
			canvas.style.padding = 0;
			canvas.width = page["original"].naturalWidth;
			canvas.height = page["original"].naturalHeight;

			ctx.fillStyle = '#F0F0F0';
			ctx.fillRect(0, 0, canvas.width, canvas.height);

			ctx.beginPath();
			ctx.moveTo(0, 0);
			ctx.lineTo(canvas.width, canvas.height);
			ctx.lineWidth = 5;
			ctx.strokeStyle = '#CC0000';
			ctx.stroke();

			ctx.beginPath();
			ctx.moveTo(0, canvas.height);
			ctx.lineTo(canvas.width, 0);
			ctx.lineWidth = 5;
			ctx.strokeStyle = '#CC0000';
			ctx.stroke();

			return canvas.toDataURL("image/png", 1.0);
		},
		hexToRgba: function (hex, alpha = 1) {
			try {
				hex = hex.replace(/^#/, '');
				if (hex.length === 3) {
					hex = hex.split('').map(char => char + char).join('');
				}
				const bigint = parseInt(hex, 16);
				const r = (bigint >> 16) & 255;
				const g = (bigint >> 8) & 255;
				const b = bigint & 255;
				return 'rgba(' + r + ', ' + g + ', ' + b + ', ' + alpha + ')';
			}
			catch (ex) {
				return 'rgba(0, 0, 0, 1)';
			}
		},
		paintPage: function (pageNumber) {
			try {
				var page = docuMasker.drawing.getPage(pageNumber);
				if (page != null) {
					var boundingWidth = document.getElementById("editor-pane").getBoundingClientRect().width;
					var boundingHeight = document.getElementById("editor-pane").getBoundingClientRect().height;
					const canvasWHFactor = boundingWidth / boundingHeight;
					const imgWHFactor = page["original"].naturalWidth / page["original"].naturalHeight;
					const imgWidth = ((imgWHFactor >= canvasWHFactor) ? boundingWidth : boundingHeight * imgWHFactor) * docuMasker.drawing._zoom;
					const imgHeight = ((imgWHFactor >= canvasWHFactor) ? boundingWidth / imgWHFactor : boundingHeight) * docuMasker.drawing._zoom;
					docuMasker.drawing._canvas.width = imgWidth;
					docuMasker.drawing._canvas.height = imgHeight;
					docuMasker.drawing._ctx.drawImage(page["original"], 0, 0, imgWidth, imgHeight);
					//console.log("boundingWidth: " + boundingWidth + "boundingHeight: " + boundingHeight + " imgWidth: " + imgWidth + " imgHeight: " + imgHeight)

					for (var p = 0; p < docuMasker.drawing._undoBuffer.length; p++) {
						if (docuMasker.drawing._undoBuffer[p]["pageNumber"] == pageNumber) {
							var strokeStyle = docuMasker._workMode ? docuMasker.drawing.hexToRgba(docuMasker.drawing._undoBuffer[p]["strokeStyle"], 0.5) : docuMasker.drawing._undoBuffer[p]["strokeStyle"];
							var scaleFactor = imgWidth / docuMasker.drawing._undoBuffer[p]["canvasWidth"];
							var startX = docuMasker.drawing._undoBuffer[p]["minX"] * scaleFactor;
							var startY = docuMasker.drawing._undoBuffer[p]["minY"] * scaleFactor;
							var endX = docuMasker.drawing._undoBuffer[p]["maxX"] * scaleFactor;

							docuMasker.drawing._ctx.beginPath();
							docuMasker.drawing._ctx.moveTo(startX, startY + docuMasker.drawing._undoBuffer[p]["lineWidth"] / 2 * scaleFactor);
							docuMasker.drawing._ctx.lineTo(endX, startY + docuMasker.drawing._undoBuffer[p]["lineWidth"] / 2 * scaleFactor);
							docuMasker.drawing._ctx.lineWidth = docuMasker.drawing._undoBuffer[p]["lineWidth"] * scaleFactor;
							docuMasker.drawing._ctx.strokeStyle = strokeStyle;
							docuMasker.drawing._ctx.stroke();
						}
					}
				} else {
					docuMasker.drawing._ctx.clearRect(0, 0, docuMasker.drawing._canvas.width, docuMasker.drawing._canvas.height);
				}
			} catch (ex) {
				console.log(ex);
			}
		},
		paintCurrentPage: function () {
			docuMasker.drawing.paintPage(docuMasker.drawing._currentPage);
		},
		paintFinalPage: function (pageNumber) {
			try {
				var page = docuMasker.drawing.getPage(pageNumber);
				if (page != null) {
					var canvas = document.createElement('canvas');
					var ctx = canvas.getContext('2d');
					canvas.style.margin = 0;
					canvas.style.padding = 0;
					canvas.width = page["original"].naturalWidth;
					canvas.height = page["original"].naturalHeight;
					ctx.drawImage(page["original"], 0, 0, page["original"].naturalWidth, page["original"].naturalHeight);

					for (var p = 0; p < docuMasker.drawing._undoBuffer.length; p++) {
						if (docuMasker.drawing._undoBuffer[p]["pageNumber"] == pageNumber) {
							var scaleFactor = page["original"].naturalWidth / docuMasker.drawing._undoBuffer[p]["canvasWidth"];
							var startX = docuMasker.drawing._undoBuffer[p]["minX"] * scaleFactor;
							var startY = docuMasker.drawing._undoBuffer[p]["minY"] * scaleFactor;
							var endX = docuMasker.drawing._undoBuffer[p]["maxX"] * scaleFactor;

							ctx.beginPath();
							ctx.moveTo(startX, startY + docuMasker.drawing._undoBuffer[p]["lineWidth"] / 2 * scaleFactor);
							ctx.lineTo(endX, startY + docuMasker.drawing._undoBuffer[p]["lineWidth"] / 2 * scaleFactor);
							ctx.lineWidth = docuMasker.drawing._undoBuffer[p]["lineWidth"] * scaleFactor;
							ctx.strokeStyle = docuMasker.drawing._undoBuffer[p]["strokeStyle"];
							ctx.stroke();
						}
					}
					return canvas.toDataURL("image/png", 1.0);
				}
			} catch (ex) {
				console.log(ex);
			}
			return null;
		},
		addPage: function (dataUrl) {
			var pageNumber = docuMasker.drawing._pages.length;
			var tc1 = document.createElement("div");
			tc1.classList.add('thumb-c1');
			var tc2 = document.createElement("div");
			tc2.classList.add('thumb-c2');
			var tc3 = document.createElement("div");
			tc3.classList.add('thumb-c3');
			var thumb = new Image;
			var original = new Image;
			thumb.classList.add('thumb-image');
			thumb.setAttribute("data-pagenumber", pageNumber);
			thumb.setAttribute("id", "thumb_" + pageNumber);
			document.getElementById("left-pane-content").appendChild(tc1);
			tc1.appendChild(tc2);
			tc2.appendChild(tc3);
			tc3.appendChild(thumb);
			thumb.src = dataUrl;
			original.src = dataUrl;
			var pgd = document.createElement("div");
			pgd.classList.add('thumb-pagenumber');
			pgd.innerText = (pageNumber + 1).toString();
			tc1.appendChild(pgd);

			docuMasker.drawing._pages[pageNumber] = {
				"original": original, 
				"pageNumber": pageNumber
			};

			thumb.addEventListener('click', ce => {
				docuMasker.drawing.setCurrentPage(1 * ce.target.getAttribute("data-pagenumber"));
				docuMasker.drawing.paintPage(docuMasker.drawing._currentPage);
			});
			original.addEventListener('load', ce => {
				docuMasker.drawing.paintCurrentPage();
			});
			thumb.addEventListener('load', ce => {
				var initialLoad = true;
				if (1 * ce.target.getAttribute("data-pagenumber") == 0 && initialLoad) {
					docuMasker.drawing.setCurrentPage(0);
					docuMasker.drawing.paintPage(docuMasker.drawing._currentPage);
					initialLoad = false;
				}
			});
		},
		loadDocument: function (data) {
			docuMasker.drawing.reset();
			docuMasker.drawing.original = data["Original"] || {};
			for (var i = 0; i < data.pages.length; i++) {
				docuMasker.drawing.addPage(data.pages[i]["imageType"] + ";base64," + data.pages[i]["base64Content"]);
			}
			if(docuMasker._doOcr) {
				docuMasker.drawing.recognize();
			}
		},
		saveDocument: function () {
			docuMasker.displayContainer("wait-container");
			var doc = {
				"pages": [],
				"Original": docuMasker.drawing.original
			};
			for (var p = 0; p < docuMasker.drawing._pages.length; p++) {
				doc["pages"][p] = {
					"dataUrl": docuMasker.drawing.paintFinalPage(p)
				};
			}

			var xhr = new XMLHttpRequest();
			xhr.open("POST", "/Document/FromImg", true);
			xhr.responseType = 'blob';
			xhr.addEventListener('progress', e => { });
			xhr.addEventListener('error', e => { docuMasker.hideContainer("wait-container"); alert(xhr.responseText); });
			xhr.addEventListener('abort', e => { docuMasker.hideContainer("wait-container"); alert(docuMasker.localizer("The operation was aborted.")); });
			xhr.addEventListener('load', e => {
				if (xhr.readyState == 4) {
					if (xhr.status == 200) {
						docuMasker.hideContainer("wait-container");
						var filename = (docuMasker._currentDocument ? docuMasker._currentDocument : "");
						if (!filename) {
							var disposition = xhr.getResponseHeader('Content-Disposition');
							if (disposition && disposition.indexOf('attachment') !== -1) {
								var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
								var matches = filenameRegex.exec(disposition);
								if (matches != null && matches[1]) filename = matches[1].replace(/['"]/g, '');
							}
						}
						if (!filename) {
							filename = "Maskat dokument.pdf";
						}
						filename = filename.lastIndexOf(".") > 0 ? filename.substring(0, filename.lastIndexOf(".")) + ".pdf" : filename + ".pdf";

						var type = xhr.getResponseHeader('Content-Type') || "application/pdf";
						var blob = new Blob([xhr.response], { type: type });
						if (typeof window.navigator.msSaveBlob !== 'undefined') {
							window.navigator.msSaveBlob(blob, filename);
						} else {
							var URL = window.URL || window.webkitURL;
							var downloadUrl = URL.createObjectURL(blob);

							if (filename) {
								var a = document.createElement("a");
								if (typeof a.download === 'undefined') {
									window.location = downloadUrl;
								} else {
									a.href = downloadUrl;
									a.download = filename;
									document.body.appendChild(a);
									a.click();
								}
							} else {
								window.location = downloadUrl;
							}
							URL.revokeObjectURL(downloadUrl);
							docuMasker.drawing._dirty = false;
						}
					} else {
						docuMasker.hideContainer("wait-container");
						console.log(xhr.status + " " + xhr.statusText);
						alert(xhr.status + " " + xhr.statusText);
					}
				}
			});
			xhr.send(JSON.stringify(doc));
		},
		sendDocument: function (email) {
			// console.log(JSON.stringify(email));
			docuMasker.displayContainer("wait-container");
			var doc = {
				"pages": [],
				"Original": docuMasker.drawing.original,
				"email": email
			};

			for (var p = 0; p < docuMasker.drawing._pages.length; p++) {
				doc["pages"][p] = {
					"dataUrl": docuMasker.drawing.paintFinalPage(p)
				};
			}

			var xhr = new XMLHttpRequest();
			xhr.open("POST", "/Document/FromImg", true);
			xhr.responseType = 'blob';
			xhr.addEventListener('progress', e => { });
			xhr.addEventListener('error', e => { docuMasker.hideContainer("wait-container"); alert(xhr.responseText); });
			xhr.addEventListener('abort', e => { docuMasker.hideContainer("wait-container"); alert(docuMasker.localizer("The operation was aborted.")); });
			xhr.addEventListener('load', e => {
				if (xhr.readyState == 4) {
					if (xhr.status == 200) {
						docuMasker.hideContainer("wait-container");
					} else {
						docuMasker.hideContainer("wait-container");
						console.log(xhr.status + " " + xhr.statusText);
						alert(xhr.status + " " + xhr.statusText);
					}
				}
			});
			xhr.send(JSON.stringify(doc));
		}
	}
};