// Xinha Language Combined Translation File
//
// LANG: "fr", ENCODING: UTF-8
//
// INSTRUCTIONS TO TRANSLATORS
// ===========================================================================
//
// Your translation must be in UTF-8 Character Encoding.
//
// This is a JSON encoded file (plus comments), strings should be double-quote
// only, do not use single quotes to surround strings - "hello", not 'hello'
// do not have a trailing comma after the last entry in a section.
//
// Only full line comments are allowed (that a comments occupy entire lines).
//
// Search for the __NEW_TRANSLATIONS__ section below, this is where you will
// want to focus, this section includes things that do not presently have a 
// translation or for which the translation needs to be checked for accuracy.
//
// In the New Translations section a translation string is one of the following
//
//  "English String Here" : ""
//     This means it is not translated yet, add your translation...
//     "English String Here" : "Klingon String Here"
//
//  "English String Here" : "Translated String Here"
//     This means that an existing translation for this string, in some other
//     section has been found, and used.  Check that it is approprite for this
//     section and if it is, that's fine leave it as is, otherwise change as
//     appropriate.
//
//  "English String Here" : "<<AnotherSection>>"
//     This means use the same translation for this string as <<AnotherSection>>
//     this saves you re-tranlating strings.  If the Context of this section
//     and the context of AnotherSection seem the same, that's fine leave it
//     using that translation, but if this section needs a different translation, 
//     you can provide it by replacing the link (<<AnotherSection>>) with that
//     new translation.  For example - a "Table" in say "DataPlugin" is 
//     perhaps translated differently to "Table" in "FurniturePlugin".
//
// TESTING YOUR TRANSLATION
// ===========================================================================
// Simply place your translation file on your webserver somewhere for example
//
//   /xinha/lang/merged/fr.js
//
// and then tell Xinha where to get it (before loading XinhaCore.js) by 
//
//  _editor_lang              = 'fr';
//  _editor_lang_merged_file  = '/xinha/lang/merged/fr.js';
//
// Xinha will load your new language definition.
//
// SUBMITTING YOUR TRANSLATION
// ===========================================================================
// Simply create a Ticket on the Xinha website and attach your translation 
// file.
//
// The Xinha developers will take your file and use the 
//     contrib/lc_split_merged_file.php
// script to load it into the Xinha distribution.

{
    "Abbreviation": {
        "Abbreviation": "Abréviation",
        "Cancel": "Annuler",
        "Delete": "Supprimer",
        "Expansion:": "Explication",
        "OK": "OK"
    },
    "AboutBox": {
        "About this editor": "A propos",
        "Close": "Fermer"
    },
    "BackgroundImage": {
        "Cancel": "Annuler",
        "Remove Current Background": "Supprimer le fond actuel",
        "Set Page Background Image": "Définir l'Image de Fond",
        "Set page background image": "Définir l'image de fond"
    },
    "CharCounter": {
        "Chars": "Caractères",
        "Words": "Mots"
    },
    "CharacterMap": {
        "Insert special character": "Insérer un caractère spécial"
    },
    "ColorPicker": {
        "Close": "Fermer",
        "Color: ": "Couleur",
        "OK": "OK"
    },
    "ContextMenu": {
        "C_ell Properties...": "P_ropriétés de la cellule...",
        "Chec_k Link...": "_Vérifier le lien...",
        "Copy": "Copier",
        "Create a link": "Créer un lien",
        "Current URL is": "L'URL courante est",
        "Cut": "Couper",
        "De_lete Column": "_Supprimer la colonne",
        "Delete the current column": "Supprimer cette colonne",
        "Delete the current row": "Supprimer la rangée courante",
        "How did you get here? (Please report!)": "Comment êtes-vous arrivé ici ? (Reportez le bug SVP !)",
        "I_nsert Row Before": "Insérer une rangée a_vant",
        "In_sert Row After": "Insér_er une rangée après",
        "Insert C_olumn After": "Insérer une colonne après",
        "Insert _Column Before": "I_nsérer une colonne avant",
        "Insert a new column after the current one": "Insérer une nouvelle colonne après celle-ci",
        "Insert a new column before the current one": "Insérer une nouvelle rangée avant celle-ci",
        "Insert a new row after the current one": "Insérer une nouvelle rangée après celle-ci",
        "Insert a new row before the current one": "Insérer une nouvelle rangée avant celle-ci",
        "Insert a paragraph after the current node": "Insérer un paragraphe après le noeud courant",
        "Insert a paragraph before the current node": "Insérer un paragraphe avant le noeud courant",
        "Insert paragraph after": "Insérer un paragraphe après",
        "Insert paragraph before": "Insérer un paragraphe avant",
        "Justify Center": "Aligner au centre",
        "Justify Full": "Justifier",
        "Justify Left": "Aligner à gauche",
        "Justify Right": "Aligner à droite",
        "Link points to:": "Le lien pointe sur:",
        "Make lin_k...": "Convertir en lien...",
        "Opens this link in a new window": "Ouvrir ce lien dans une nouvelle fenêtre",
        "Paste": "Coller",
        "Please confirm that you want to remove this element:": "Confirmer la suppression de cet élément:",
        "Please confirm that you want to unlink this element.": "Voulez-vous vraiment enlever le lien présent sur cet élément.",
        "Remove the $elem Element...": "Supprimer Élément $elem...",
        "Remove this node from the document": "Supprimer ce noeud du document",
        "Ro_w Properties...": "Pr_opriétés de la rangée...",
        "Show the Table Cell Properties dialog": "Afficher la boite de propriété des cellules",
        "Show the Table Properties dialog": "Afficher la boite de propriété de tableau",
        "Show the Table Row Properties dialog": "Afficher la boite de propriété des rangées",
        "Show the image properties dialog": "Afficher le dialogue des propriétés d'image",
        "Unlink the current element": "Enlever le lien sur cet élément",
        "_Delete Row": "Suppr_imer une rangée",
        "_Image Properties...": "_Propriétés de l'image...",
        "_Modify Link...": "_Modifier le lien...",
        "_Remove Link...": "_Supprimer le lien...",
        "_Table Properties...": "Proprié_tés de la table..."
    },
    "CreateLink": {
        "Are you sure you wish to remove this link?": "Confirmez-vous la suppression de ce lien ?",
        "Cancel": "Annuler",
        "Insert/Modify Link": "Insérer / Modifier un lien",
        "New window (_blank)": "Nouvelle fenêtre (_blank)",
        "None (use implicit)": "Aucune (implicite)",
        "OK": "OK",
        "Other": "Autre",
        "Same frame (_self)": "Même frame (_self)",
        "Target:": "Cible",
        "Title (tooltip):": "Texte alternatif",
        "Top frame (_top)": "Frame principale (_top)",
        "URL:": "URL:",
        "You need to select some text before creating a link": "Vous devez sélectionner du texte avant de créer un lien"
    },
    "DynamicCSS": {
        "Choose stylesheet": "Choisir feuille de style",
        "Default": "Défaut",
        "Undefined": "Non défini"
    },
    "EditTag": {
        "Cancel": "Annuler",
        "Edit HTML for selected text": "Editer le code HTML du texte sélectionné",
        "OK": "OK",
        "Tag Editor": "Editeur de tag HTML"
    },
    "Equation": {
        "Cancel": "Annuler",
        "OK": "OK",
        "Preview": "Aperçu "
    },
    "ExtendedFileManager": {
        "Absbottom": "Absbottom",
        "Absmiddle": "Absmiddle",
        "Align": "Alignement",
        "Alt": "Alt",
        "Baseline": "Baseline",
        "Border": "Bordure",
        "Border Color": "Couleur de la bordure",
        "Bottom": "Bas",
        "Cancel": "Annuler",
        "Clear": "Effacer",
        "Color": "Couleur",
        "Constrain Proportions": "Maintenir les proportions",
        "Copy": "Copier",
        "Crop": "Recadrer",
        "Cut": "Couper",
        "Directory": "Répertoire",
        "Directory Up": "Remonter",
        "Edit": "Modifier",
        "File Manager": "Gestionnaire de fichiers",
        "Filename:": "Nom du fichier:",
        "Filesize:": "Taille du fichier:",
        "Flip Horizontal": "Symétrie hor.",
        "Flip Image": "Symétrie",
        "Flip Vertical": "Symétrie ver.",
        "GIF format is not supported, image editing not supported.": "Le format GIF n'est pas supporté, édition d'image impossible.",
        "Height": "Hauteur",
        "Height:": "Hauteur:",
        "Insert File Link": "Insérer un lien vers fichier",
        "Invalid base directory:": "Dossier racine invalide:",
        "JPEG High": "JPEG haut",
        "JPEG Low": "JPEG bas",
        "JPEG Medium": "JPEG moyen",
        "Left": "Gauche",
        "Loading": "Chargement",
        "Lock": "Verrouiller",
        "Margin": "Marge",
        "Marker": "Marqueur",
        "Measure": "Règle",
        "Middle": "Milieu",
        "New Folder": "Nouveau dossier",
        "New window (_blank)": "Nouvelle fenêtre (_blank)",
        "No Files Found": "Aucun fichier",
        "No Image Available": "Aucune image disponible",
        "None (use implicit)": "Aucune (implicite)",
        "Not set": "Indéfini",
        "OK": "OK",
        "Padding": "Marge intérieure",
        "Positioning of this image": "Position de cette image",
        "Preview": "Aperçu ",
        "Quality:": "Qualité:",
        "Refresh": "Actualiser",
        "Rename": "Renommer",
        "Resize": "Redimen.",
        "Right": "Droite",
        "Rotate": "Pivoter",
        "Rotate Image": "Pivoter l'image",
        "Same frame (_self)": "Même frame (_self)",
        "Save": "Enregistrer",
        "Start X:": "Départ X",
        "Start Y:": "Départ Y",
        "Target Window": "Fenêtre cible",
        "Texttop": "Texttop",
        "Title (tooltip)": "Tooltip",
        "Toggle marker color": "Changer la couleur du marqueur",
        "Top": "Haut",
        "Top frame (_top)": "Frame principale (_top)",
        "Trash": "Corbeille",
        "Upload": "Envoyer",
        "W:": "W:",
        "Width": "Largeur",
        "Width:": "Largeur:",
        "You must select some text before making a new link.": "Vous devez sélectionner du texte avant de faire un nouveau lien.",
        "Zoom": "Zoom"
    },
    "FindReplace": {
        "Case sensitive search": "Recherche sensible à la casse",
        "Clear": "Effacer",
        "Done": "Fin",
        "Enter the text you want to find": "Texte à trouver",
        "Find and Replace": "Chercher et Remplacer",
        "Highlight": "Surligner",
        "Inform a replacement word": "Indiquez un mot de remplacement",
        "Next": "Suivant",
        "Options": "Options",
        "Replace with:": "Remplacer par",
        "Search for:": "Chercher",
        "Substitute all occurrences": "Remplacer toutes les occurences",
        "Substitute this occurrence?": "Remplacer cette occurrence ?",
        "Undo": "Annuler",
        "Whole words only": "Mots entiers seulement",
        "found item": "élément trouvé",
        "found items": "éléments trouvés",
        "not found": "non trouvé",
        "replaced item": "élément remplacé",
        "replaced items": "éléments remplacés"
    },
    "FormOperations": {
        "Insert a Form.": "Insérer un formulaire",
        "Insert a check box.": "Insérer une case à cocher",
        "Insert a multi-line text field.": "Insérer un champ texte à lignes multiples",
        "Insert a radio button.": "Insérer un bouton radio",
        "Insert a select field.": "Insérer une boite de sélection",
        "Insert a submit/reset button.": "Insérer un bouton de soumission/annulation",
        "Insert a text, password or hidden field.": "Insérer un texte, un mot de passe ou un champ invisible"
    },
    "Forms": {
        "Cancel": "Annuler",
        "Image URL:": "URL",
        "Name": "Nom",
        "Name/ID:": "Nom/ID",
        "OK": "OK",
        "Options": "Options",
        "Rows:": "Lignes",
        "Size:": "Taille",
        "Text:": "Texte"
    },
    "FullPage": {
        "Alternate style-sheet:": "Feuille CSS alternative",
        "Background color:": "Couleur d'arrière plan",
        "Cancel": "Annuler",
        "Character set:": "Jeu de caractères",
        "DOCTYPE:": "DOCTYPE",
        "Description:": "Description",
        "Document properties": "Propriétés du document",
        "Document title:": "Titre du document",
        "Keywords:": "Mots clés",
        "OK": "OK",
        "Primary style-sheet:": "Feuille CSS primaire",
        "Text color:": "Couleur de texte",
        "UTF-8 (recommended)": "UTF-8 (recommandé)"
    },
    "FullScreen": {
        "Maximize/Minimize Editor": "Agrandir/Réduire l'éditeur"
    },
    "HorizontalRule": {
        "Alignment:": "Alignement",
        "Cancel": "Annuler",
        "Center": "Centre",
        "Color:": "Couleur",
        "Height:": "Hauteur",
        "Horizontal Rule": "Règle horizontale",
        "Insert/edit horizontal rule": "Insérer une règle horizontale",
        "Layout": "Layout",
        "Left": "Gauche",
        "No shading": "Pas d'ombre",
        "OK": "OK",
        "Right": "Droite",
        "Style": "Style",
        "Width:": "Largeur",
        "percent": "pourcent",
        "pixels": "pixels"
    },
    "HtmlTidy": {
        "Auto-Tidy": "Tidy automatique",
        "Don't Tidy": "Tidy non utilisé",
        "HTML Tidy": "HTML Tidy",
        "Tidy failed.  Check your HTML for syntax errors.": "Tidy a échoué. Vérifiez votre HTML for des erreurs de syntaxe"
    },
    "ImageManager": {
        "Absbottom": "Absbottom",
        "Absmiddle": "Absmiddle",
        "Angle:": "Angle",
        "Baseline": "Baseline",
        "Bottom": "Bas",
        "Cancel": "Annuler",
        "Clear": "Effacer",
        "Constrain Proportions": "Conserver les proportions",
        "Crop": "Recadrer",
        "Directory": "Répertoire",
        "Directory Up": "Remonter",
        "Edit": "Editer",
        "Filename:": "Nom",
        "Flip Horizontal": "Symétrie horizontale",
        "Flip Image": "Symétrie",
        "Flip Vertical": "Symétrie verticale",
        "Folder Name:": "Nom du répertoire",
        "GIF format is not supported, image editing not supported.": "Format GIF non supporté, édition d'image non supportée",
        "Height:": "Hauteur",
        "Image Format": "Format d'image",
        "Insert Image": "Insérer une image",
        "Invalid base directory:": "Répertoire de base invalide:",
        "JPEG High": "JPEG haut",
        "JPEG Low": "JPEG bas",
        "JPEG Medium": "JPEG moyen",
        "Left": "Gauche",
        "Lock": "Cadenas",
        "Marker": "Marqueur",
        "Measure": "Mesure",
        "Middle": "Milieu",
        "New Folder": "Nouveau répertoire",
        "No Image Available": "Aucune image disponible",
        "No Images Found": "Aucune image trouvée",
        "Not set": "Indéfini",
        "OK": "OK",
        "Positioning of this image": "Position de cette image",
        "Quality:": "Qualité",
        "Refresh": "Rafraîchir",
        "Resize": "Retailler",
        "Right": "Droite",
        "Rotate": "Pivoter",
        "Rotate Image": "Rotation",
        "Save": "Sauver",
        "Start X:": "Début X",
        "Start Y:": "Début Y",
        "Texttop": "Texttop",
        "Top": "Haut",
        "Trash": "Détruire",
        "W:": "L:",
        "Width:": "Largeur"
    },
    "InlineStyler": {
        "Background": "Arrière plan",
        "Baseline": "Baseline",
        "Border": "Bordure",
        "Bottom": "Bas",
        "Center": "Centre",
        "Char": "Charactère",
        "Collapsed borders": "Bordure effondrés",
        "FG Color": "Couleur de face",
        "Float": "Flotteur",
        "Height": "Hauteur",
        "Image URL": "URL pour l'image",
        "Justify": "Justifié",
        "Layout": "Layout",
        "Left": "Gauche",
        "Margin": "Marge",
        "Middle": "Milieu",
        "None": "Aucun",
        "Padding": "Remplissage",
        "Right": "Droite",
        "Text align": "Alignement",
        "Top": "Haut",
        "Vertical align": "Vertical",
        "Width": "Largeur",
        "percent": "pourcent",
        "pixels": "pixels"
    },
    "InsertAnchor": {
        "Anchor name": "Nom de l'ancre",
        "Cancel": "Annuler",
        "Delete": "Supprimer",
        "Insert Anchor": "Insérer une ancre",
        "OK": "OK"
    },
    "InsertImage": {
        "Absbottom": "Absbottom",
        "Absmiddle": "Absmiddle",
        "Alignment:": "Alignement",
        "Alternate text:": "Texte alternatif",
        "Baseline": "Baseline",
        "Border thickness:": "Epaisseur bordure",
        "Bottom": "Bas",
        "Cancel": "Annuler",
        "Enter the image URL here": "Entrer l'URL de l'image ici",
        "For browsers that don't support images": "Pour les navigateurs qui ne supportent pas les images",
        "Horizontal padding": "Marge horizontale interne",
        "Horizontal:": "Horizontal",
        "Image Preview:": "Prévisualisation",
        "Image URL:": "URL",
        "Insert Image": "Insérer une image",
        "Layout": "Layout",
        "Leave empty for no border": "Laisser vide pour pas de bordure",
        "Left": "Gauche",
        "Middle": "Milieu",
        "Not set": "Indéfini",
        "OK": "OK",
        "Positioning of this image": "Position de cette image",
        "Preview": "Aperçu ",
        "Preview the image in a new window": "Prévisualiser l'image dans une nouvelle fenêtre",
        "Right": "Droite",
        "Spacing": "Espacement",
        "Texttop": "Texttop",
        "Top": "Haut",
        "Vertical padding": "Marge verticale interne",
        "Vertical:": "Vertical",
        "You must enter the URL": "Vous devez entrer l'URL"
    },
    "InsertMarquee": {
        "Background-Color:": "Couleur de fond",
        "Behavior:": "Comportement",
        "Cancel": "Annuler",
        "Direction:": "Direction",
        "Height:": "Hauteur",
        "Insert scrolling marquee": "Insérer marquee défilant",
        "Left": "Gauche",
        "Name": "Nom",
        "Name/ID:": "Nom/ID",
        "OK": "OK",
        "Right": "Droite",
        "Scroll Amount:": "Quantité de défilement",
        "Scroll Delay:": "Délai du défilement",
        "Speed Control": "Controle de vitesse",
        "Text:": "Texte",
        "Width:": "Largeur"
    },
    "InsertNote": {
        "Cancel": "Annuler"
    },
    "InsertPagebreak": {
        "Page break": "Séparateur de page"
    },
    "InsertPicture": {
        "Absbottom": "Absbottom",
        "Absmiddle": "Absmiddle",
        "Alignment:": "Alignement",
        "Alternate text:": "Texte alternatif",
        "Baseline": "Baseline",
        "Border thickness:": "Epaisseur bordure",
        "Bottom": "Bas",
        "Cancel": "Annuler",
        "Enter the image URL here": "Entrer l'URL de l'image ici",
        "For browsers that don't support images": "Pour les navigateurs qui ne supportent pas les images",
        "Height:": "Hauteur",
        "Horizontal padding": "Marge horizontale interne",
        "Horizontal:": "Horizontal",
        "Image Preview:": "Prévisualisation",
        "Image URL:": "URL",
        "Insert Image": "Insérer une image",
        "Layout": "Layout",
        "Leave empty for no border": "Laisser vide pour pas de bordure",
        "Left": "Gauche",
        "Middle": "Milieu",
        "Not set": "Indéfini",
        "OK": "OK",
        "Open file in new window": "Ouvrir le fichier dans une nouvelle fenêtre",
        "Positioning of this image": "Position de cette image",
        "Preview": "Prévisualisation",
        "Preview the image in a new window": "Prévisualiser l'image dans une nouvelle fenêtre",
        "Right": "Droite",
        "Size": "Taille",
        "Spacing": "Espacement",
        "Texttop": "Texttop",
        "Top": "Haut",
        "Upload file": "Télécharger",
        "Vertical padding": "Marge verticale interne",
        "Vertical:": "Vertical",
        "Width:": "Largeur"
    },
    "InsertSmiley": {
        "Insert Smiley": "Insérer un smiley"
    },
    "InsertSnippet": {
        "Cancel": "Annuler"
    },
    "InsertSnippet2": {
        "Cancel": "Annuler"
    },
    "InsertTable": {
        "Absbottom": "Absbottom",
        "Absmiddle": "Absmiddle",
        "Alignment:": "Alignement",
        "Baseline": "Baseline",
        "Border": "Bordure",
        "Border thickness:": "Epaisseur bordure",
        "Bottom": "Bas",
        "Cancel": "Annuler",
        "Caption": "Étiquette",
        "Cell padding:": "Marge interne",
        "Cell spacing:": "Espacement",
        "Cols:": "Colonnes",
        "Em": "Em",
        "Fixed width columns": "Colonnes à taille fixe",
        "Insert Table": "Insérer un tableau",
        "Layout": "Layout",
        "Leave empty for no border": "Laisser vide pour pas de bordure",
        "Left": "Gauche",
        "Middle": "Milieu",
        "Not set": "Indéfini",
        "Number of columns": "Nombre de colonnes",
        "Number of rows": "Nombre de lignes",
        "OK": "OK",
        "Percent": "Pourcent",
        "Pixels": "Pixels",
        "Positioning of this table": "Position du tableau",
        "Right": "Droite",
        "Rows:": "Lignes",
        "Space between adjacent cells": "Espace entre les cellules adjacentes",
        "Space between content and border in cell": "Espace entre le contenu et la bordure d'une cellule",
        "Spacing": "Espacement",
        "Texttop": "Texttop",
        "Top": "Haut",
        "Width of the table": "Largeur du tableau",
        "Width unit": "Unités de largeur",
        "Width:": "Largeur",
        "You must enter a number of columns": "Vous devez entrer le nombre de colonnes",
        "You must enter a number of rows": "Vous devez entrer le nombre de lignes"
    },
    "LangMarks": {
        "&mdash; language &mdash;": "&mdash; Langue &mdash;",
        "English": "anglais",
        "French": "français",
        "Greek": "grec",
        "Latin": "latin",
        "language select": "Sélection de la langue"
    },
    "Linker": {
        "Are you sure you wish to remove this link?": "Confirmez-vous la suppression de ce lien ?",
        "Cancel": "Annuler",
        "Email Address:": "Adresse email",
        "Email Link": "Lien email",
        "Insert/Modify Link": "Insérer / Modifier un lien",
        "Message Template:": "Message",
        "Name:": "Nom",
        "New Window": "Nouvelle fenêtre",
        "OK": "OK",
        "Ordinary Link": "Lien standard",
        "Popup Window": "Fenêtre popup",
        "Remove Link": "Supprimer",
        "Same Window (jump out of frames)": "Même fenêtre (sort des frames)",
        "Size:": "Taille",
        "Subject:": "Sujet",
        "Target:": "Cible",
        "URL Link": "Lien URL",
        "URL:": "URL:",
        "You must select some text before making a new link.": "Vous devez sélectionner un texte avant de créer un nouveau lien"
    },
    "ListType": {
        "Choose list style type (for ordered lists)": "Choisissez le style de liste (pour les listes ordonnées)",
        "Decimal numbers": "Nombres décimaux",
        "Lower greek letters": "Lettres grecques minuscule",
        "Lower latin letters": "Lettres latines minuscule",
        "Lower roman numbers": "Nombres romains minuscule",
        "Upper latin letters": "Lettres latines majuscule",
        "Upper roman numbers": "Nombres romains majuscule"
    },
    "MootoolsFileManager": {
        "Insert File Link": "Insérer un lien vers fichier",
        "You must select some text before making a new link.": "Vous devez sélectionner un texte avant de créer un nouveau lien"
    },
    "NoteServer": {
        "Add GUIDO Code in a textbox on the page": "Ajouter le code source GUIDO dans un cadre",
        "Add MIDI link to allow students to hear the music": "Ajouter un lien MIDI pour permettre aux étudiants d'écouter la partition",
        "Cancel": "Annuler",
        "Format": "Format",
        "Guido code": "Code Guido",
        "Image Preview": "Aperçu de l'image",
        "Image in applet": "Image dans une applet",
        "Insert GUIDO Music Notation": "Insérer une partition musicale GUIDO",
        "MIDI File": "Fichier MIDI",
        "OK": "OK",
        "Options": "Options",
        "Preview": "Aperçu ",
        "Preview the image in a new window": "Prévisualiser l'image dans une nouvelle fenêtre",
        "Source Code": "Code source",
        "Zoom": "Zoom"
    },
    "Opera": {
        "The Paste button does not work in Mozilla based web browsers (technical security reasons). Press CTRL-V on your keyboard to paste directly.": "Le bouton Coller ne fonctionne pas sur les navigateurs basés sur Mozilla (pour des raisons de sécurité). Pressez CTRL-V au clavier pour coller directement."
    },
    "PSLocal": {
        "Cancel": "Annuler"
    },
    "PasteText": {
        "Cancel": "Annuler",
        "OK": "OK",
        "Paste as Plain Text": "Copier comme texte pur"
    },
    "PersistentStorage": {
        "Cancel": "Annuler",
        "Copy": "Copier",
        "Delete": "Supprimer",
        "Directory Up": "Remonter",
        "File Manager": "Gestionnaire de fichiers",
        "Filename": "Nom",
        "Insert Image": "Insérer une image",
        "New Folder": "Nouveau répertoire",
        "Save": "Enregistrer",
        "You must select some text before making a new link.": "Vous devez sélectionner un texte avant de créer un nouveau lien"
    },
    "QuickTag": {
        "ATTRIBUTES": "ATTRIBUTS",
        "Cancel": "Annuler",
        "Colors": "Couleurs",
        "Enter the TAG you want to insert": "Entrez la balise que vous voulez insérer",
        "No CSS class avaiable": "Pas de classe CSS accessible",
        "OPTIONS": "OPTIONS",
        "Ok": "OK",
        "Quick Tag Editor": "Editeur rapide de balise",
        "TAGs": "Balises",
        "There are some unclosed quote": "Il y a des apostrophes mal fermées",
        "This attribute already exists in the TAG": "Cet attribute existe déjà sur cette balise",
        "You have to select some text": "Vous devez sélectionner du texte"
    },
    "SaveSubmit": {
        "Ready": "Prêt",
        "Save": "Enregistrer",
        "Saving...": "Enregistrement...",
        "in progress": "en cours"
    },
    "SetId": {
        "Cancel": "Annuler",
        "Delete": "Supprimer",
        "OK": "OK"
    },
    "SmartReplace": {
        "ClosingDoubleQuotes": "«",
        "Convert all quotes and dashes in the current document": "Convertir tous les guillemets et tirets dans le document actuel",
        "Enable automatic replacements": "Activer le remplacement automatique",
        "OK": "OK",
        "OpeningDoubleQuotes": "»",
        "SmartReplace Settings": "Paramètres SmartReplace"
    },
    "SpellChecker": {
        "Cancel": "Annuler",
        "Dictionary": "Dictionnaire",
        "Finished list of mispelled words": "Liste des mots mal orthographiés",
        "I will open it in a new page.": "Ouverture dans une nouvelle fenêtre",
        "Ignore": "Ignorer",
        "Ignore all": "Tout ignorer",
        "No mispelled words found with the selected dictionary.": "Aucune erreur orthographique avec le dictionnaire sélectionné.",
        "OK": "OK",
        "Original word": "Mot original",
        "Please confirm that you want to open this link": "Veuillez confirmer l'ouverture de ce lien",
        "Please wait.  Calling spell checker.": "Veuillez patienter.  Appel du correcteur.",
        "Please wait: changing dictionary to": "Veuillez patienter. Changement du dictionnaire vers",
        "Re-check": "Vérifier encore",
        "Replace": "Remplacer",
        "Replace all": "Tout remplacer",
        "Replace with": "Remplacer par",
        "Revert": "Annuler",
        "Spell-check": "Correction",
        "Suggestions": "Suggestions",
        "This will drop changes and quit spell checker.  Please confirm.": "Ceci fermera la fenêtre et annulera les modifications. Veuillez confirmer."
    },
    "Stylist": {
        "Styles": "Styles"
    },
    "SuperClean": {
        "Cancel": "Annuler",
        "Clean up HTML": "Nettoyer le code HTML",
        "General tidy up and correction of some problems.": "Nettoyage générique et correction des problèmes mineurs.",
        "OK": "OK",
        "Please select from the following cleaning options...": "Veuillez sélectionner une option de nettoyage.",
        "Remove custom font sizes.": "Supprimer les tailles de polices personnalisées.",
        "Remove custom text colors.": "Supprimer les couleurs de texte personalisées.",
        "Remove custom typefaces (font \"styles\").": "Supprimer les polices personalisées (font \"styles\").",
        "Remove lang attributes.": "Supprimer les attributs de langue."
    },
    "TableOperations": {
        "All four sides": "Quatre cotés",
        "Borders": "Bordures",
        "Cancel": "Annuler",
        "Caption": "Étiquette",
        "Cell Properties": "Propriétés de cellule",
        "Cell properties": "Cell properties",
        "Delete cell": "Supprimer une cellule",
        "Delete column": "Supprimer la colonne",
        "Delete row": "Supprimer une rangée",
        "Description": "Description",
        "Frames": "Vues",
        "Insert cell after": "Insérer une cellule après",
        "Insert cell before": "Insérer une cellule avant",
        "Insert column after": "Insérer une colonne après",
        "Insert column before": "Insérer une colonne avant",
        "Insert row after": "Insérer une rangée après",
        "Insert row before": "Insérer une rangée avant",
        "Merge cells": "Fusionner les cellules",
        "No rules": "Aucune règle",
        "No sides": "Aucun côté",
        "OK": "OK",
        "Padding": "Remplissage",
        "Please click into some cell": "Cliquer sur une cellule",
        "Row Properties": "Propriétés de rangée",
        "Row properties": "Propriétés de rangée",
        "Rows": "Lignes",
        "Rules will appear between all rows and columns": "Règles entre les rangées et les cellules",
        "Rules will appear between columns only": "Règles entre les colonnes seulement",
        "Rules will appear between rows only": "Règles entre les rangées seulement",
        "Spacing": "Espacement",
        "Spacing and padding": "Espacement et remplissage",
        "Split column": "Diviser une colonne",
        "Split row": "Diviser la rangée",
        "Summary": "Sommaire",
        "Table Properties": "Propriétés de table",
        "Table properties": "Propriétés de table",
        "The bottom side only": "Côté du bas seulement",
        "The left-hand side only": "Côté gauche seulement",
        "The right and left sides only": "Côté gauche et droit seulement",
        "The right-hand side only": "Côté droit seulement",
        "The top and bottom sides only": "Côté haut et bas seulement",
        "The top side only": "Côté haut seulement",
        "Xinha cowardly refuses to delete the last cell in row.": "Il est impossible de supprimer la dernière cellule de la rangée.",
        "Xinha cowardly refuses to delete the last column in table.": "Il est impossible de supprimer la dernière colonne de la table.",
        "Xinha cowardly refuses to delete the last row in table.": "Il est impossible de supprimer la dernière rangée de la table",
        "pixels": "pixels"
    },
    "Template": {
        "Cancel": "Annulation",
        "Insert template": "Insérer un template"
    },
    "UnFormat": {
        "All": "Tout",
        "All HTML:": "Tout le HTML",
        "Cancel": "Annuler",
        "Cleaning Area": "Zone de nettoyage",
        "Cleaning options": "Options de nettoyage",
        "Formatting:": "Format",
        "OK": "OK",
        "Page Cleaner": "Nettoyeur de page",
        "Select which types of formatting you would like to remove.": "Sélectionnez quel type de formatage vous voulez supprimer.",
        "Selection": "Sélection"
    },
    "UnsavedChanges": {
        "You have unsaved changes in the editor": "Vous n'avez pas enregistré vos modifications"
    },
    "Xinha": {
        "&#8212; format &#8212;": "&#8212; Format &#8212;",
        "About this editor": "A propos",
        "Address": "Adresse",
        "Background Color": "Surlignage",
        "Bold": "Gras",
        "Bulleted List": "Liste à puces",
        "Clean content pasted from Word": "Nettoyage du contenu copié depuis Word",
        "Clear Inline Font Specifications": "Supprimer paramètres inline de la police",
        "Clear MSOffice tags": "Supprimer tags MSOffice",
        "Close": "Fermer",
        "Constructing object": "Construction de l'objet",
        "Copy selection": "Copier la sélection",
        "Create Statusbar": "Construction de la barre de status",
        "Create Toolbar": "Construction de la barre d'icones",
        "Current style": "Style courant",
        "Cut selection": "Couper la sélection",
        "Decrease Indent": "Diminuer le retrait",
        "Direction left to right": "Direction de gauche à droite",
        "Direction right to left": "Direction de droite à gauche",
        "ENTER": "ENTREE",
        "Editor Help": "Aide de l'éditeur",
        "Finishing": "Chargement bientôt terminé",
        "Font Color": "Couleur de police",
        "Formatted": "Formaté",
        "Generate Xinha framework": "Génération de Xinha",
        "Heading 1": "Titre 1",
        "Heading 2": "Titre 2",
        "Heading 3": "Titre 3",
        "Heading 4": "Titre 4",
        "Heading 5": "Titre 5",
        "Heading 6": "Titre 6",
        "Headings": "Titres",
        "Help using editor": "Aide",
        "Horizontal Rule": "Ligne horizontale",
        "Increase Indent": "Augmenter le retrait",
        "Init editor size": "Initialisation de la taille d'édition",
        "Insert Table": "Insérer un tableau",
        "Insert Web Link": "Insérer un lien",
        "Insert/Modify Image": "Insérer / Modifier une image",
        "Insert/Overwrite": "Insertion / Remplacement",
        "Italic": "Italique",
        "Justify Center": "Centrer",
        "Justify Full": "Justifier",
        "Justify Left": "Aligner à gauche",
        "Justify Right": "Aligner à droite",
        "Keyboard shortcuts": "Raccourcis clavier",
        "Loading in progress. Please wait!": "Chargement en cours. Veuillez patienter!",
        "Loading plugin $plugin": "Chargement du plugin $plugin",
        "Normal": "Normal",
        "Ordered List": "Liste numérotée",
        "Paste from clipboard": "Coller depuis le presse-papier",
        "Path": "Chemin",
        "Print document": "Imprimer document",
        "Redoes your last action": "Répéter la dernière action",
        "Register plugin $plugin": "Enregistrement du plugin $plugin",
        "Remove formatting": "Supprimer mise en forme",
        "SHIFT-ENTER": "SHIFT+ENTREE",
        "Save as": "Enregistrer sous",
        "Select all": "Tout sélectionner",
        "Set format to paragraph": "Applique le format paragraphe",
        "Split Block": "Séparer les blocs",
        "Strikethrough": "Barré",
        "Subscript": "Indice",
        "Superscript": "Exposant",
        "The editor provides the following key combinations:": "L'éditeur fournit les combinaisons de touches suivantes :",
        "Toggle Borders": "Afficher / Masquer les bordures",
        "Toggle HTML Source": "Afficher / Masquer code source",
        "Underline": "Souligné",
        "Undoes your last action": "Annuler la dernière action",
        "Would you like to clear font colours?": "Voulez-vous supprimer les couleurs ?",
        "Would you like to clear font sizes?": "Voulez-vous supprimer les tailles ?",
        "Would you like to clear font typefaces?": "Voulez-vous supprimer les types ?",
        "You are in TEXT MODE.  Use the [<>] button to switch back to WYSIWYG.": "Vous êtes en MODE TEXTE.  Appuyez sur le bouton [<>] pour retourner au mode WYSIWYG.",
        "insert linebreak": "Insère un saut de ligne",
        "new paragraph": "Nouveau paragraphe"
    },
    "__NEW_TRANSLATIONS__": {
        "CharCounter": {
            "... in progress": "",
            "HTML": ""
        },
        "ColorPicker": {
            "Click a color...": "",
            "Sample": "",
            "Web Safe: ": ""
        },
        "ContextMenu": {
            "Delete Cell": "",
            "Insert Cell After": "",
            "Insert Cell Before": "",
            "Merge Cells": ""
        },
        "DefinitionList": {
            "definition description": "",
            "definition list": "",
            "definition term": ""
        },
        "Dialogs": {
            "Some Text Here": ""
        },
        "EditTag": {
            "Edit Tag By Peg": ""
        },
        "Equation": {
            "!=": "",
            "!in": "",
            "&gt;-": "",
            "&gt;=": "",
            "&lt;=": "",
            "&lt;=&gt;": "",
            "&lt;x&gt;": "",
            "&nbsp; `!` &nbsp;": "",
            "&nbsp; `.` &nbsp;": "",
            "&nbsp; `0` &nbsp;": "",
            "&nbsp; `2` &nbsp;": "",
            "&nbsp; `3` &nbsp;": "",
            "&nbsp; `4` &nbsp;": "",
            "&nbsp; `5` &nbsp;": "",
            "&nbsp; `6` &nbsp;": "",
            "&nbsp; `7` &nbsp;": "",
            "&nbsp; `8` &nbsp;": "",
            "&nbsp; `9` &nbsp;": "",
            "&nbsp; `e` &nbsp;": "",
            "&nbsp;&nbsp;`1` &nbsp;": "",
            "&nbsp;`+{::}`&nbsp;": "",
            "&nbsp;`-:\\ `": "",
            "&nbsp;`-{::}`&nbsp;": "",
            "&nbsp;`C`&nbsp;": "",
            "&nbsp;`cos`": "",
            "&nbsp;`ln`&nbsp;": "",
            "&nbsp;`pi` &nbsp;": "",
            "&nbsp;`sin`": "",
            "&nbsp;`tan`": "",
            "&nbsp;`times`&nbsp;": "",
            "&quot;text&quot;": "",
            "'+formula+'": "",
            "((n),(k))": "",
            "(x+1)/(x-1)": "",
            "*": "",
            "**": "",
            "+-": "",
            "-&gt;": "",
            "-&lt;": "",
            "-:": "",
            "-=": "",
            "//": "",
            "/_": "",
            ":.": "",
            "=&gt;": "",
            "@": "",
            "[[a,b],[c,d]]": "",
            "\\\\": "",
            "\\nClick in the box to use your keyboard or use the buttons\\n": "",
            "^^": "",
            "^^^": "",
            "__|": "",
            "_|_": "",
            "`!=`": "",
            "`!in`": "",
            "`&and;`": "",
            "`&cap;`": "",
            "`&cup;`": "",
            "`&gt;-`": "",
            "`&gt;=`": "",
            "`&lt;=&gt;`": "",
            "`&lt;=`": "",
            "`&lt;x&gt;`": "",
            "`&or;`": "",
            "`&quot;text&quot;`": "",
            "`((n),(k))`": "",
            "`(x+1)/(x-1)`": "",
            "`**`": "",
            "`*`": "",
            "`+-`": "",
            "`-&gt;`": "",
            "`-&lt;`": "",
            "`-:`": "",
            "`-=`": "",
            "`//`": "",
            "`/_`": "",
            "`:.`": "",
            "`=&gt;`": "",
            "`@`": "",
            "`[[a,b],[c,d]]`": "",
            "`\\\\`": "",
            "`__|`": "",
            "`_|_`": "",
            "`AA`": "",
            "`aleph`": "",
            "`alpha`": "",
            "`and`": "",
            "`bara`": "",
            "`bba`": "",
            "`bbba`": "",
            "`beta`": "",
            "`CC`": "",
            "`cca`": "",
            "`chi`": "",
            "`darr`": "",
            "`ddota`": "",
            "`del`": "",
            "`Delta`": "",
            "`delta`": "",
            "`diamond`": "",
            "`dota`": "",
            "`dy/dx`": "",
            "`EE`": "",
            "`epsi`": "",
            "`eta`": "",
            "`fra`": "",
            "`Gamma`": "",
            "`gamma`": "",
            "`grad`": "",
            "`harr`": "",
            "`hArr`": "",
            "`hata`": "",
            "`if`": "",
            "`in`": "",
            "`int`": "",
            "`iota`": "",
            "`kappa`": "",
            "`lambda`": "",
            "`Lambda`": "",
            "`lArr`": "",
            "`larr`": "",
            "`lim_(x-&gt;oo)`": "",
            "`log`": "",
            "`mu`": "",
            "`NN`": "",
            "`nn`": "",
            "`not`": "",
            "`nu`": "",
            "`o+`": "",
            "`o.`": "",
            "`O/`": "",
            "`oint`": "",
            "`omega`": "",
            "`Omega`": "",
            "`oo`": "",
            "`or`": "",
            "`ox`": "",
            "`Phi`": "",
            "`phi`": "",
            "`Pi`": "",
            "`pi`": "",
            "`prod`": "",
            "`prop`": "",
            "`Psi`": "",
            "`psi`": "",
            "`QQ`": "",
            "`quad`": "",
            "`rArr`": "",
            "`rho`": "",
            "`root(n)(x)`": "",
            "`RR`": "",
            "`sfa`": "",
            "`sigma`": "",
            "`Sigma`": "",
            "`sqrt(x)`": "",
            "`square`": "",
            "`stackrel(-&gt;)(+)`": "",
            "`sub`": "",
            "`sube`": "",
            "`sum`": "",
            "`sup`": "",
            "`supe`": "",
            "`tau`": "",
            "`Theta`": "",
            "`theta`": "",
            "`TT`": "",
            "`tta`": "",
            "`uarr`": "",
            "`ula`": "",
            "`upsilon`": "",
            "`uu`": "",
            "`veca`": "",
            "`vv`": "",
            "`x_(mn)`": "",
            "`Xi`": "",
            "`xi`": "",
            "`xx`": "",
            "`zeta`": "",
            "`ZZ`": "",
            "`|-&gt;`": "",
            "`|--`": "",
            "`|==`": "",
            "`|__`": "",
            "`|~`": "",
            "`~=`": "",
            "`~|`": "",
            "`~~`": "",
            "AA": "",
            "aleph": "",
            "alpha": "",
            "and": "",
            "AsciiMath Formula Input": "",
            "AsciiMathML Example": "",
            "bara": "",
            "Based on ASCIIMathML by": "",
            "bba": "",
            "bbba": "",
            "beta": "",
            "CC": "",
            "cca": "",
            "chi": "",
            "darr": "",
            "ddota": "",
            "del": "",
            "Delta": "",
            "delta": "",
            "diamond": "",
            "dota": "",
            "dy/dx": "",
            "EE": "",
            "epsi": "",
            "eta": "",
            "For more information on AsciiMathML visit this page:": "",
            "Formula Editor": "",
            "fra": "",
            "gamma": "",
            "Gamma": "",
            "grad": "",
            "hArr": "",
            "harr": "",
            "hata": "",
            "if": "",
            "in": "",
            "Input": "",
            "int": "",
            "int_a^bf(x)dx": "",
            "iota": "",
            "kappa": "",
            "Lambda": "",
            "lambda": "",
            "larr": "",
            "lArr": "",
            "lim_(x-&gt;oo)": "",
            "mu": "",
            "NN": "",
            "nn": "",
            "nnn": "",
            "not": "",
            "nu": "",
            "o+": "",
            "o.": "",
            "O/": "",
            "oint": "",
            "omega": "",
            "Omega": "",
            "oo": "",
            "or": "",
            "ox": "",
            "Phi": "",
            "phi": "",
            "pi": "",
            "Pi": "",
            "prod": "",
            "prop": "",
            "psi": "",
            "Psi": "",
            "QQ": "",
            "quad": "",
            "rArr": "",
            "rho": "",
            "root(n)(x)": "",
            "RR": "",
            "sfa": "",
            "sigma": "",
            "Sigma": "",
            "sqrt(x)": "",
            "square": "",
            "stackrel(-&gt;)(+)": "",
            "sub": "",
            "sube": "",
            "sum": "",
            "sum_(n=1)^oo": "",
            "sup": "",
            "supe": "",
            "tau": "",
            "Theta": "",
            "theta": "",
            "TT": "",
            "tta": "",
            "uarr": "",
            "ula": "",
            "upsilon": "",
            "uu": "",
            "uuu": "",
            "veca": "",
            "vv": "",
            "vvv": "",
            "x^(m+n)": "",
            "x_(mn)": "",
            "Xi": "",
            "xi": "",
            "xx": "",
            "zeta": "",
            "ZZ": "",
            "|-&gt;": "",
            "|--": "",
            "|==": "",
            "|__": "",
            "|~": "",
            "~=": "",
            "~|": "",
            "~~": ""
        },
        "FancySelects": {
            "'+opt.text+'": ""
        },
        "FindReplace": {
            "';\r\n  var tagc = '": ""
        },
        "FormOperations": {
            "Enter the name for new option.": "",
            "Form Editor": "",
            "Message Sent": "",
            "Please Select...": ""
        },
        "Forms": {
            "'onClick'=": "",
            "Access Key:": "",
            "Action URL:": "",
            "Button Script": "",
            "Checked": "",
            "Columns:": "",
            "Default text (optional)": "",
            "Dimensions": "",
            "Disabled": "",
            "Encoding:": "",
            "For Control:": "",
            "Form": "",
            "Form Element: FIELDSET": "",
            "Form Element: INPUT": "",
            "Form Element: LABEL": "",
            "Form Element: SELECT": "",
            "Form Element: TEXTAREA": "",
            "Form handler script": "",
            "Form Name:": "",
            "Get": "",
            "Hard": "",
            "Height in number of rows": "",
            "HTML-Form to CGI (default)": "",
            "Image source": "",
            "Initial Text:": "",
            "Insert/Edit Form": "",
            "Insert/Edit Form Element FIELDSET": "",
            "Insert/Edit Form Element INPUT": "",
            "Insert/Edit Form Element LABEL": "",
            "Insert/Edit Form Element SELECT": "",
            "Insert/Edit Form Element TEXTAREA": "",
            "Javascript for button click": "",
            "Label:": "",
            "Legend:": "",
            "Max length:": "",
            "Maximum number of characters accepted": "",
            "Method:": "",
            "multipart Form Data (File-Upload)": "",
            "Name of the form input": "",
            "Name of the form select": "",
            "name of the textarea": "",
            "normal": "",
            "nowrap": "",
            "Off": "",
            "Physical": "",
            "Please enter a Label": "",
            "Post": "",
            "pre": "",
            "Read Only": "",
            "Size of text box in characters": "",
            "Soft": "",
            "Tab Index:": "",
            "Target Frame:": "",
            "URL of image": "",
            "Value of the form input": "",
            "Value:": "",
            "Virtual": "",
            "Width in number of characters": "",
            "Wrap Mode:": "",
            "You must enter a Name": ""
        },
        "FullPage": {
            "...": "",
            "cyrillic (ISO-8859-5)": "",
            "cyrillic (KOI8-R)": "",
            "cyrillic (WINDOWS-1251)": "",
            "western (ISO-8859-1)": ""
        },
        "Gecko": {
            "The Paste button does not work in this browser for security reasons. Press CTRL-V on your keyboard to paste directly.": ""
        },
        "HorizontalRule": {
            "&#x00d7;": "",
            "&nbsp;": "",
            "Insert/Edit Horizontal Rule": ""
        },
        "InlineStyler": {
            "CSS Style": "",
            "-": "<<Equation>>"
        },
        "InsertNote": {
            "Insert": "",
            "Insert footnote": "",
            "Insert Note": ""
        },
        "InsertPagebreak": {
            "Page Break": ""
        },
        "InsertSnippet": {
            "\\n  This is an information about something\\n": "",
            "Hide preview": "",
            "Insert as": "",
            "Insert Snippet": "",
            "InsertSnippet for Xinha": "",
            "Link1": "",
            "Link2": "",
            "Link3": "",
            "Link4": "",
            "Link5": "",
            "Show preview": "",
            "This is an information about something": "",
            "Variable": ""
        },
        "InsertSnippet2": {
            "All Categories": "",
            "Filter": "",
            "Insert as HTML": "",
            "Insert as template variable": "",
            "Only search word beginning": "",
            "HTML": "<<CharCounter>>",
            "Insert Snippet": "<<InsertSnippet>>",
            "InsertSnippet for Xinha": "<<InsertSnippet>>",
            "Variable": "<<InsertSnippet>>"
        },
        "InsertTable": {
            "Caption for the table": "",
            "Collapse borders:": "",
            "Layou": "",
            "Style of the border": ""
        },
        "LangMarks": {
            "', '": ""
        },
        "Linker": {
            "(px)": "",
            "Anchor-Link": "",
            "Anchor:": "",
            "Location Bar:": "",
            "Menu Bar:": "",
            "PopupWindow": "",
            "Resizeable:": "",
            "Scrollbars:": "",
            "Shows On Hover": "",
            "Status Bar:": "",
            "Title:": "",
            "Toolbar:": ""
        },
        "Opera": {
            "MARK": ""
        },
        "PasteText": {
            "Insert text in new paragraph": ""
        },
        "PreserveScripts": {
            "JavaScript": "",
            "PHP": ""
        },
        "QuickSnippet": {
            "'+snippet.name+'": "",
            "Insert After": "",
            "Insert Before": "",
            "This snippet can be inserted before/above, or after/below the current position...": "",
            "Cancel": "Annuler",
            "Insert Snippet": "<<InsertSnippet>>"
        },
        "QuickTag": {
            "',\r\n                           'cl': '": ""
        },
        "SetId": {
            "ID/Name:": "",
            "Set Id and Name": "",
            "Set Id/Name": "",
            "Set ID/Name": ""
        },
        "SmartReplace": {
            "ClosingSingleQuote": "",
            "OpeningSingleQuote": "",
            "SmartReplace": ""
        },
        "SuperClean": {
            "Clean bad HTML from Microsoft Word.": "",
            "Clean Selection Only": "",
            "Cleaning Scope": "",
            "Please stand by while cleaning in process...": "",
            "Remove alignment (left/right/justify).": "",
            "Remove all classes (CSS).": "",
            "Remove All HTML Tags": "",
            "Remove all styles (CSS).": "",
            "Remove emphasis and annotations.": "",
            "Remove Paragraphs": "",
            "Remove superscripts and subscripts.": "",
            "Replace directional quote marks with non-directional quote marks.": "",
            "Vigorously purge HTML from Microsoft Word.": ""
        },
        "TableOperations": {
            "Cell Type:": "",
            "Cells down": "",
            "Cells to the right, and": "",
            "Do Not Change": "",
            "Frame and borders": "",
            "Header (th)": "",
            "Merge current cell with:": "",
            "Normal (td)": "",
            "Columns": "<<Forms>>",
            "Merge Cells": "<<ContextMenu>>"
        },
        "WebKit": {
            "The Paste button does not work in this browser for security reasons. Press CTRL-V on your keyboard to paste directly.": "<<Gecko>>"
        },
        "Xinha": {
            "&#8212; font &#8212;": "",
            "&#8212; size &#8212;": "",
            "1 (8 pt)": "",
            "2 (10 pt)": "",
            "3 (12 pt)": "",
            "4 (14 pt)": "",
            "5 (18 pt)": "",
            "6 (24 pt)": "",
            "7 (36 pt)": "",
            "Arial": "",
            "Courier New": "",
            "CTRL-0 (zero)": "",
            "CTRL-1 .. CTRL-6": "",
            "CTRL-A": "",
            "CTRL-B": "",
            "CTRL-C": "",
            "CTRL-E": "",
            "CTRL-I": "",
            "CTRL-J": "",
            "CTRL-L": "",
            "CTRL-N": "",
            "CTRL-R": "",
            "CTRL-S": "",
            "CTRL-U": "",
            "CTRL-V": "",
            "CTRL-X": "",
            "CTRL-Y": "",
            "CTRL-Z": "",
            "Error Loading Xinha.  Developers, check the Error Console for information.": "",
            "Georgia": "",
            "Impact": "",
            "Loading Core": "",
            "Loading plugins": "",
            "MS Word Cleaner": "",
            "Select Color": "",
            "Tahoma": "",
            "Times New Roman": "",
            "Touch here first to activate editor.": "",
            "Verdana": "",
            "Waiting for Iframe to load...": "",
            "WingDings": "",
            "Xinha": ""
        },
        "BackgroundImage": {
            "__ TRANSLATOR NOTE __": "*** BACKGROUNDIMAGE IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "Set Background": ""
        },
        "ClientsideSpellcheck": {
            "__ TRANSLATOR NOTE __": "*** CLIENTSIDESPELLCHECK IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "Spell Check using ieSpell": ""
        },
        "ExtendedFileManager": {
            "__ TRANSLATOR NOTE __": "*** EXTENDEDFILEMANAGER IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "10%": "",
            "100%": "",
            "200%": "",
            "25%": "",
            "50%": "",
            "75%": "",
            ">List View": "",
            ">Thumbnail View": "",
            "A:": "",
            "D:": "",
            "File List": "",
            "Folder": "",
            "GIF": "",
            "H:": "",
            "Image Editor": "",
            "Image Selection": "",
            "Maximum folder size limit reached. Upload disabled.": "",
            "Please enter value": "",
            "PNG": "",
            "Preset": "",
            "Rotate 180 &deg;": "",
            "Rotate 90 &deg; CCW": "",
            "Rotate 90 &deg; CW": "",
            "X:": "",
            "Xinha Image Editor": "",
            "Y:": ""
        },
        "Filter": {
            "__ TRANSLATOR NOTE __": "*** FILTER IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "Filter": "<<InsertSnippet2>>"
        },
        "ImageManager": {
            "__ TRANSLATOR NOTE __": "*** IMAGEMANAGER IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "Flickr Picture List": "",
            "Flickr Pictures": "",
            "Flickr Selection": "",
            "Flickr Username/Email": "",
            "Image List": "",
            "Keyword": "",
            "No Photos Found": "",
            "No Videos Found": "",
            "This Server": "",
            "YouTube Selection": "",
            "YouTube Username": "",
            "YouTube Video List": "",
            "YouTube Videos": "",
            "A:": "<<ExtendedFileManager>>",
            "D:": "<<ExtendedFileManager>>",
            "GIF": "<<ExtendedFileManager>>",
            "H:": "<<ExtendedFileManager>>",
            "Image Editor": "<<ExtendedFileManager>>",
            "Image Selection": "<<ExtendedFileManager>>",
            "PNG": "<<ExtendedFileManager>>",
            "Rotate 180 &deg;": "<<ExtendedFileManager>>",
            "Rotate 90 &deg; CCW": "<<ExtendedFileManager>>",
            "Rotate 90 &deg; CW": "<<ExtendedFileManager>>",
            "X:": "<<ExtendedFileManager>>",
            "Y:": "<<ExtendedFileManager>>"
        },
        "InsertMarquee": {
            "__ TRANSLATOR NOTE __": "*** INSERTMARQUEE IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "Alternate": "",
            "Continuous": "",
            "Marquee Editor": "",
            "Slide": ""
        },
        "InsertPicture": {
            "__ TRANSLATOR NOTE __": "*** INSERTPICTURE IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "Leave empty for not defined": "",
            " Open file in new window": ""
        },
        "NoteServer": {
            "__ TRANSLATOR NOTE __": "*** NOTESERVER IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "120%": "",
            "150%": "",
            "80%": "",
            "GUIDO Code": "",
            "With Mozilla, the applet will not be visible in editor, but only in Web page after submitting.": "",
            "Zoom :": "",
            "100%": "<<ExtendedFileManager>>"
        },
        "PSLocal": {
            "__ TRANSLATOR NOTE __": "*** PSLOCAL IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "Confirm": "",
            "Enable": "",
            "Enable Gears in order to use local document storage and configuration.": "",
            "Enabling Local Storage": "",
            "Install": "",
            "Learn About Local Storage": "",
            "This will reload the page, causing you to lose any unsaved work.  Press \"OK\" to reload.": "",
            "Xinha uses Google Gears to enable local document storage.  With Gears installed, you can save drafts of your documents on your hard drive, configure Xinha to look the way you want, and carry this information wherever you use Xinha on the web.": ""
        },
        "PSServer": {
            "__ TRANSLATOR NOTE __": "*** PSSERVER IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "File: ": "",
            "Import": ""
        },
        "PersistentStorage": {
            "__ TRANSLATOR NOTE __": "*** PERSISTENTSTORAGE IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "Details": "",
            "File Browser": "",
            "Hello    There C ": "",
            "Hello  There A ": "",
            "Hello \" There B \"": "",
            "Hello ' There D '": "",
            "List of Places": "",
            "New Document": "",
            "Open": "",
            "Open Document": "",
            "Places": "",
            "Please enter the name of the directory you'd like to create.": "",
            "Save Document": "",
            "This will erase any unsaved content.  If you're certain, please click OK to continue.": "",
            "Web URL": "",
            "Confirm": "<<PSLocal>>",
            "File List": "<<ExtendedFileManager>>",
            "Insert": "<<InsertNote>>"
        },
        "SpellChecker": {
            "__ TRANSLATOR NOTE __": "*** SPELLCHECKER IS UNSUPPORTED (TRANSLATE AT YOUR DISCRETION) ***",
            "HTMLArea Spell Checker": "",
            "Info": "",
            "Learn": "",
            "pliz weit ;-)": "",
            "Spell Checker": ""
        }
    }
}